<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Community_project extends MY_Controller
{	
	function __construct()
	{
    	parent::__construct();
    	$this->load->library('form_validation');
    	$this->load->model('model_basic');    
    	$this->load->model('assignment_model'); 
    	$this->load->model('community_project_model');
    	$this->load->model('modelbasic');
    	
	}

	public function index()
	{
		$user_id=$this->session->userdata('front_user_id');	
		
		$getAllUserAssignment= $this->assignment_model->getAllUserAssignment($user_id);
		if(!empty($getAllUserAssignment))
		{
			$data['assigned']=array();
			$data['pending']=array();
			$data['resubmitted']=array();
			$data['submitted']=array();
			$data['accepted']=array();
			foreach($getAllUserAssignment as $assignment)
			{
				$assignmentStaus=$this->model_basic->getValueArray('project_master','assignment_status',array('userId'=>$user_id,'assignmentId'=>$assignment['id']));
				if($assignmentStaus==1)
				{
					$data['submitted'][]=$assignment;
				}
				elseif($assignmentStaus==2)
				{
					$data['pending'][]=$assignment;
				}
				elseif($assignmentStaus==3)
				{
					$data['accepted'][]=$assignment;
				}
				elseif($assignmentStaus==4)
				{
					$data['resubmitted'][]=$assignment;
				}
				else
				{
					$data['assigned'][]=$assignment;
				}
			}
		}
		else
		{
			$data=array();
		}

		//print_r($data);die;
		$this->load->view('community_projects_list_view',$data);
	}

	public function saveRegistration()
	{
	    $id = $this->session->userdata('front_user_id');

	    if (isset($_POST['save_video_details'])) {
	        // Retrieve all form data
	        $vol_id = $this->input->post('event_id');
	        $uu_id = $this->input->post('uu_id');
	        $created = date('Y-m-d H:i:s');

	        // Validate data if necessary
	        if (!empty($vol_id)) {
	            // Prepare data for insert
	            $companyData = array(
	                'VolunteerId' => $vol_id,
	                'userId' => $id, // Include the user_id for the insert
	                'created' => $created
	            );

	            // Insert a new record
	            $companyInsert = $this->db->insert('user_volunteer_relation', $companyData);
	        } else {
	            $this->session->set_flashdata('fail', 'Please fill all the required fields.');
	        }

	        // Redirect to company dashboard
	        redirect(base_url() . 'volunteering_opportunity/volunteering_opportunity_detail/' . $uu_id);
	    }
	}

	public function deleteRegistration()
	{
	    $id = $this->session->userdata('front_user_id'); // Get current user id

	    // Retrieve event_id and uu_id from POST data
	    $vol_id = $this->input->post('event_id');
	    $uu_id = $this->input->post('uu_id');

	    // Check if event_id is provided
	    if (isset($_POST['delete_video_details'])) {
	        // Prepare the condition for deletion
	        $this->db->where('VolunteerId', $vol_id);
	        $this->db->where('userId', $id);
	        
	        // Delete the record
	        $this->db->delete('user_volunteer_relation');
	        
	        // Set a success message
	        $this->session->set_flashdata('success', 'Volunteer Unfollow successfully.');
	    } else {
	        // Set an error message if event_id is missing
	        $this->session->set_flashdata('fail', 'Event ID is required for deletion.');
	    }

	    // Redirect back to the detail page
	    redirect(base_url() . 'volunteering_opportunity/volunteering_opportunity_detail/' . $uu_id);
	}


	public function community_project_dashboard()
	{
		$data['event']=$this->modelbasic->getTrendingEventData();
		$data['jobs']=array();
		if(($FRONT_USER_SESSION_ID > 0) || $FRONT_USER_SESSION_ID == 0){
			$data['jobs']=$this->modelbasic->getValues('company_RFP','company_RFP.id,company_RFP.description,company_RFP.rate,company_RFP.name,company_RFP.start_date,company_RFP.end_date,company_RFP.profile_image,company_RFP.duration',array('company_RFP.status'=>1),'result_array','','',array('company_RFP.created','DESC'),3);
		}
		$this->load->view('community_projects_dashboard',$data);
	}

	public function saveImagecovercompany()
	{
	    // Reset cover image session
	    $this->session->set_userdata('cover_image', ' ');

	    // Get the user ID from the session
	    $id = $this->session->userdata('front_user_id');

	    // Check if files are uploaded
	    if (isset($_FILES) && !empty($_FILES))
	    {
	        if (isset($_FILES[0]['name']) && $_FILES[0]['name'] != "")
	        {
	            // Prepare the file for upload
	            $files = $_FILES[0];
	            $_FILES = array();
	            $_FILES['image'] = $files;
	            $field = 'image';
	            $uploadFileData = array();
	            $isUploaded = array();
	            $image_error = array();

	            // Call the file upload method
	            $isUploaded = $this->model_basic->fileUpload($uploadFileData, $field, time(), file_upload_s3_path() . "users/");

	            if (!$isUploaded || $uploadFileData[$field . '_err'] != "")
	            {
	                // If file upload fails, reset session cover image
	                $this->session->set_userdata('cover_image', ' ');
	            }
	            else
	            {
	                // File upload succeeded, process the image
	                $file_name = $uploadFileData[$field];
	                $this->session->set_userdata('cover_image', $file_name);

	                // Crop and create thumbnail of the image
	                $this->model_basic->ImageCropMaster('1200', '250', file_upload_s3_path() . 'users/' . $file_name, file_upload_s3_path() . 'users/thumbs/' . $file_name, $quality = 80);

	                // Check if the user_id already exists in the company table
	                $this->db->where('user_id', $id);
	                $query = $this->db->get('community_project');

	                if ($query->num_rows() > 0)
	                {
	                    // If user_id exists, update the cover image
	                    $previousImage = $this->model_basic->getValue('community_project', "banner_image", "user_id=" . $id);

	                    // Delete previous images from the server
	                    @unlink(file_upload_s3_path() . 'users/' . $previousImage);
	                    @unlink(file_upload_s3_path() . 'users/thumbs/' . $previousImage);

	                    // Update the company cover image
	                    $res = $this->model_basic->_update('community_project', 'user_id', $id, array('banner_image' => $file_name));
	                }
	                else
	                {
	                    // If user_id does not exist, insert a new record
	                    $companyData = array(
	                        'user_id' => $id,
	                        'banner_image' => $file_name
	                    );

	                    // Insert the new company data
	                    $res = $this->db->insert('community_project', $companyData);
	                }
	            }
	        }
	    }

	    // Output the cover image session data
	    echo $this->session->userdata('cover_image');
	}


	public function saveAboutData()
	{
	    $id = $this->session->userdata('front_user_id');

	    if (isset($_POST['save_abt_details'])) {
	        $about_me = $this->input->post('about_me'); // Get the about_me field using CodeIgniter's input class for security

	        if (!empty($about_me)) {
	            // Use CodeIgniter's database methods to check if the user_id already exists in the company table
	            $this->db->where('user_id', $id);
	            $query = $this->db->get('community_project');

	            if ($query->num_rows() > 0) {
	                // If the user_id exists, update the about_me field
	                $this->db->where('user_id', $id);
	                $companyUpdate = $this->db->update('community_project', array('description' => $about_me));

	                if ($companyUpdate) {
	                    $this->session->set_flashdata('success', 'About Company added successfully.');
	                } else {
	                    $this->session->set_flashdata('fail', 'Failed to update about me details.');
	                }
	            } else {
	                // If the user_id does not exist, insert a new record
	                $companyInsert = $this->db->insert('community_project', array('user_id' => $id, 'description' => $about_me));

	                if ($companyInsert) {
	                    $this->session->set_flashdata('success', 'About Company added successfully.');
	                } else {
	                    $this->session->set_flashdata('fail', 'Failed to add about me details.');
	                }
	            }
	        } else {
	            $this->session->set_flashdata('fail', 'No data provided for update.');
	        }

	        redirect(base_url() . 'marketing_company_dashboard');
	    }
	}

	public function saveCompanyData()
	{
	    $id = $this->session->userdata('front_user_id');

	    if (isset($_POST['save_comp_details'])) {
	        // Retrieve all form data
	        $companyName = $this->input->post('companyName');
	        $companyType = $this->input->post('company_type');
	        $website = $this->input->post('webSiteURL');
	        $contactEmail = $this->input->post('contactEmail');
	        $contactNumber = $this->input->post('contactNumber');
	        $address = $this->input->post('location'); // Corrected field name
	        $state = $this->input->post('location_state');
	        $city = $this->input->post('location_city');
	        $country = $this->input->post('countryy'); // Already set as 'USA'

	        // Validate data if necessary
	        if (!empty($companyName) && !empty($companyType) && !empty($website) && !empty($address) && !empty($state) && !empty($city)) {
	            // Prepare data for update/insert
	            $companyData = array(
	                'community_project_name' => $companyName,
	                'community_project_type' => $companyType,
	                'webSiteURL' => $website,
	                'contactEmail' => $contactEmail,
	                'contactNumber' => $contactNumber,
	                'location' => $address,
	                'state_id' => $state,
	                'city_id' => $city,
	                'country' => $country
	            );

	            // Check if the user_id already exists in the company table
	            $this->db->where('user_id', $id);
	            $query = $this->db->get('community_project');

	            if ($query->num_rows() > 0) {
	                // If the user_id exists, update the company details
	                $this->db->where('user_id', $id);
	                $companyUpdate = $this->db->update('community_project', $companyData);
	               	if ($companyUpdate) {
	                    $this->session->set_flashdata('success', 'Company details updated successfully.');
	                } else {
	                    $this->session->set_flashdata('fail', 'Failed to update company details.');
	                }
	            } else {
	                // If the user_id does not exist, insert a new record
	                $companyData['user_id'] = $id; // Include the user_id for the insert
	                $companyInsert = $this->db->insert('community_project', $companyData);

	                if ($companyInsert) {
	                    $this->session->set_flashdata('success', 'Company details added successfully.');
	                } else {
	                    $this->session->set_flashdata('fail', 'Failed to add Community Project details.');
	                }
	            }
	        } else {
	            $this->session->set_flashdata('fail', 'Please fill all the required fields.');
	        }

	        // Redirect to company dashboard
	        redirect(base_url() . 'marketing_company_dashboard');
	    }
	}

	public function saveVideoData()
	{
	    $id = $this->session->userdata('front_user_id');

	    if (isset($_POST['save_video_details'])) {
	        $about_me = $_POST['videoResume']; // Get the about_me field from POST

	        // Update the about_me field in the company table
	        if (isset($about_me)) {
	            $companyUpdate = $this->model_basic->_update('community_project', 'user_id', $id, array('videoLink' => $about_me));

	            if ($companyUpdate) {
	                $this->session->set_flashdata('success', 'Video uploaded successfully.');
	            } else {
	                $this->session->set_flashdata('fail', 'Failed to update Video upload.');
	            }
	        } else {
	            $this->session->set_flashdata('fail', 'No data provided for update.');
	        }

	        redirect(base_url() . 'marketing_company_dashboard');
	    }
	}

	public function prolinkData()
	{
	    $id = $this->session->userdata('front_user_id');

	    if (isset($_POST['save_pro_details'])) {
	        $pro_link = $_POST['portfolio_link']; // Get the about_me field from POST

	        // Update the about_me field in the company table
	        if (isset($pro_link)) {
	            $companyUpdate = $this->model_basic->_update('community_project', 'user_id', $id, array('portfolio_link' => $pro_link));

	            if ($companyUpdate) {
	                $this->session->set_flashdata('success', 'Portfolio Link added successfully.');
	            } else {
	                $this->session->set_flashdata('fail', 'Failed to Portfolio Link added.');
	            }
	        } else {
	            $this->session->set_flashdata('fail', 'No data provided for update.');
	        }

	        redirect(base_url() . 'marketing_company_dashboard');
	    }
	}

	public function savecompanyImage()
	{
	    // Clear previous profile image session
	    $this->session->set_userdata('profileImage', ' ');

	    // Get the user ID from the session
	    $id = $this->session->userdata('front_user_id');

	    // Check if files are uploaded
	    if (isset($_FILES) && !empty($_FILES))
	    {
	        if (isset($_FILES[0]['name']) && $_FILES[0]['name'] != "")
	        {
	            // Prepare the file for upload
	            $files = $_FILES[0];
	            $_FILES = array();
	            $_FILES['image'] = $files;
	            $field = 'image';
	            $uploadFileData = array();
	            $isUploaded = array();
	            $image_error = array();

	            // Call the file upload method
	            $isUploaded = $this->model_basic->fileUpload($uploadFileData, $field, time(), file_upload_s3_path()."users/");

	            if (!$isUploaded || $uploadFileData[$field.'_err'] != "")
	            {
	                // If file upload fails, reset session profile image
	                $this->session->set_userdata('profileImage', ' ');
	            }
	            else
	            {
	                // File upload succeeded, process the image
	                $file_name = $uploadFileData[$field];
	                $this->session->set_userdata('profileImage', $file_name);

	                // Crop and create thumbnail of the image
	                $this->model_basic->ImageCropMaster('200', '200', file_upload_s3_path().'users/'.$file_name, file_upload_s3_path().'users/thumbs/'.$file_name, $quality = 80);

	                // Check if the user_id exists in the company table
	                $this->db->where('user_id', $id);
	                $query = $this->db->get('community_project');

	                if ($query->num_rows() > 0)
	                {
	                    // If user_id exists, update the profile image
	                    $previousImage = $this->model_basic->getValue('community_project', "profileImage", "user_id=".$id);

	                    // Delete previous images from the server
	                    @unlink(file_upload_s3_path().'users/'.$previousImage);
	                    @unlink(file_upload_s3_path().'users/thumbs/'.$previousImage);

	                    // Update the company profile image
	                    $res = $this->model_basic->_update('community_project', 'user_id', $id, array('profileImage' => $file_name));
	                }
	                else
	                {
	                    // If user_id does not exist, insert a new record
	                    $companyData = array(
	                        'user_id' => $id,
	                        'profileImage' => $file_name
	                    );

	                    // Insert the new company data
	                    $res = $this->db->insert('community_project', $companyData);
	                }
	            }
	        }
	    }

	    // Output the profile image session data
	    echo $this->session->userdata('profileImage');
	}

	public function getCityList()
	{		
	  if (!empty($_POST['stateId'])) {
	    $data = $this->model_basic->getAllData('cities', 'id,city', array('state_id' => $_POST['stateId']));
	    
	    if (!empty($data)) {
	      echo '<option value="">Select City</option>';
	      foreach ($data as $value) {
	        echo '<option value="' . $value['id'] . '">' . $value['city'] . '</option>';
	      }
	    } else {
	      echo '<option value="">No cities available</option>';
	    }	
	  }
	}
	
	public function manage_assignment($id)
	{		
		$data['getAllUserAssignment'] = $this->model_basic->getAllData('assignment','*',array('teacher_id'=>$id),array('id'=>'DESC'));	
		//print_r($data);die;
		//echo $this->db->last_query();
		$this->load->view('manage_assignment_view',$data);
	}
	
	
	public function add_community_project($assignment_id='')
	{	
		
		
		$this->form_validation->set_error_delimiters('<div class="error">', '</div>');
		$this->form_validation->set_rules('assignment_name', 'Name', 'trim|required');
		$this->form_validation->set_rules('description', 'Description', 'trim|required');	
		$this->form_validation->set_rules('start_date', 'Start Date', 'trim|required');	
		$this->form_validation->set_rules('end_date', 'End Date', 'trim|required');	
		if ($this->form_validation->run())
		{
			//print_r($_POST);die;	
			
			if(!empty($this->input->post("videoLink")))
			{
				$videoLinkArr = explode("watch?v=",$this->input->post("videoLink"));
				$videoLink1    = explode("&feature=youtu.b", $videoLinkArr[1]);
				$videoLink=$videoLink1[0];
			}
			else
			{
				$videoLink = '';
			}
			$user_id=$this->session->userdata('front_user_id');	
			if($assignment_id!='')
			{

				$AddData=array('community_project_name'=> $this->input->post('assignment_name',TRUE),'description'=>$this->input->post('description',TRUE),'start_date'=>date('Y-m-d',strtotime($this->input->post('start_date',TRUE))),'end_date'=>date('Y-m-d',strtotime($this->input->post('end_date',TRUE))),'user_id'=>$user_id,'videoLink'=>$videoLink);

				$res=$this->model_basic->_update('community_project','id',$assignment_id,$AddData);
				

				$delettools = $this->model_basic->_deleteWhere('assignment_tools_relation',array('assignment_id'=>$assignment_id));
				$deletfeatures = $this->model_basic->_deleteWhere('assignment_features_relation',array('assignment_id'=>$assignment_id));


				if($_POST['tools']!='')
				{
					$tools = explode(',', $_POST['tools']);
					if(!empty($tools))
					{
						foreach($tools as $single_tool_value)
						{
							$get_tool_data=$this->model_basic->get_where('attribute_value_master',array('attributeId'=>1,'attributeValue'=>$single_tool_value));
							if(!empty($get_tool_data))
							{							
								$AddToolData=array('assignment_id'=>$assignment_id,'attribute_tools_id'=>$get_tool_data['id']);	
							}
							else
							{
								$add_tool_data=array('attributeId'=>1,'attributeValue'=>$single_tool_value);
								$add_tool=$this->model_basic->_insert('attribute_value_master',$add_tool_data);
								if($add_tool>1)
								{
									$AddToolData=array('assignment_id'=>$assignment_id,'attribute_tools_id'=>$add_tool);
								}
							}
							$insert_get_tool_data=$this->model_basic->_insert('assignment_tools_relation',$AddToolData);						
						}
					}				
				}
				if($_POST['features']!='')
				{
					$features = explode(',', $_POST['features']);
					if(!empty($features))
					{
						foreach($features as $single_features_value)
						{
							$get_features_data=$this->model_basic->get_where('attribute_value_master',array('attributeId'=>2,'attributeValue'=>$single_features_value));
							if(!empty($get_features_data))
							{							
								$AddfeaturesData=array('assignment_id'=>$assignment_id,'attribute_features_id'=>$get_features_data['id']);
							}
							else
							{
								$add_feature_data=array('attributeId'=>1,'attributeValue'=>$single_features_value);
								$add_feature=$this->model_basic->_insert('attribute_value_master',$add_feature_data);
								if($add_feature>1)
								{
									$AddfeaturesData=array('assignment_id'=>$assignment_id,'attribute_features_id'=>$add_feature);
								}

							}
							$insert_get_features_data=$this->model_basic->_insert('assignment_features_relation',$AddfeaturesData);					
						}
					}			
				}							
			}
			else
			{
				$AddData=array('community_project_name'=> $this->input->post('assignment_name',TRUE),'description'=>$this->input->post('description',TRUE),'start_date'=>date('Y-m-d',strtotime($this->input->post('start_date',TRUE))),'end_date'=>date('Y-m-d',strtotime($this->input->post('end_date',TRUE))),'user_id'=>$user_id,'created'=>date('Y-m-d H:i:s'),'videoLink'=>$videoLink,'status'=>1);	
				$res=$this->model_basic->_insert('community_project',$AddData);
				
			}
	
			if($_POST['tools']!='')
			{
				$tools = explode(',', $_POST['tools']);
				if(!empty($tools))
				{
					foreach($tools as $single_tool_value)
					{
						$get_tool_data=$this->model_basic->get_where('attribute_value_master',array('attributeId'=>1,'attributeValue'=>$single_tool_value));
						if(!empty($get_tool_data))
						{							
							$AddToolData=array('assignment_id'=>$res,'attribute_tools_id'=>$get_tool_data['id']);	
						}
						else
						{
							$add_tool_data=array('attributeId'=>1,'attributeValue'=>$single_tool_value);
							$add_tool=$this->model_basic->_insert('attribute_value_master',$add_tool_data);
							if($add_tool>1)
							{
								$AddToolData=array('assignment_id'=>$res,'attribute_tools_id'=>$add_tool);
							}
						}
						$insert_get_tool_data=$this->model_basic->_insert('assignment_tools_relation',$AddToolData);						
					}
				}				
			}
			if($_POST['features']!='')
			{
				$features = explode(',', $_POST['features']);
				if(!empty($features))
				{
					foreach($features as $single_features_value)
					{
						$get_features_data=$this->model_basic->get_where('attribute_value_master',array('attributeId'=>2,'attributeValue'=>$single_features_value));
						if(!empty($get_features_data))
						{							
							$AddfeaturesData=array('assignment_id'=>$res,'attribute_features_id'=>$get_features_data['id']);
						}
						else
						{
							$add_feature_data=array('attributeId'=>1,'attributeValue'=>$single_features_value);
							$add_feature=$this->model_basic->_insert('attribute_value_master',$add_feature_data);
							if($add_feature>1)
							{
								$AddfeaturesData=array('assignment_id'=>$res,'attribute_features_id'=>$add_feature);
							}

						}
						$insert_get_features_data=$this->model_basic->_insert('assignment_features_relation',$AddfeaturesData);					
					}
				}			
			}
			
			if($res>0)
			{
				redirect('community_project/submited_assignment/'.$user_id);
			}
			else
			{
				redirect('community_project/add_community_project');
			}
					
		}
		else
		{
			if($assignment_id!='')
			{	
				if(isset($errorMsg) && $errorMsg !='')
				{
					echo $errorMsg;die;
					$this->session->set_flashdata('fail',$errorMsg);
				}			
				$data['edit_assignment_data']=$this->assignment_model->edit_assignment_data($assignment_id);
				$data['selected_user']=$this->assignment_model->edit_assignment_selected_user($assignment_id);

			}
			$data['user_list']=$this->model_basic->getAllData('users','id,firstName,lastName,teachers_status',array('instituteId'=>$this->session->userdata('user_institute_id'),'status'=>1,'id !='=>$this->session->userdata('front_user_id')),array('teachers_status'=>'desc'));		
			//print_r($data);die;
			//print_r($this->session->all_userdata());die;
			$this->load->view('community_project_requirement_form',$data);
		}		
	}
	

	public function get_tool_name()
	{
		$res=$this->model_basic->getAllData('attribute_value_master','attributeValue',array('attributeId'=>1));
		if(!empty($res))
		{
			$data=[];
			foreach($res as $tool)
			{
				$data[]=$tool['attributeValue'];
			}
			$data++;
		}
		$datas=json_encode($data);
		print_r($datas);die;
	}

	public function get_feature_name()
	{
		$res=$this->model_basic->getAllData('attribute_value_master','attributeValue',array('attributeId'=>2));
		if(!empty($res))
		{
			$data=[];
			foreach($res as $feature)
			{
				$data[]=$feature['attributeValue'];
			}
			$data++;
		}
		$datas=json_encode($data);
		print_r($datas);die;
	}

	public function community_project_detail($assignment_id,$userId='',$sub_assig='')
	{
		$data['event']=$this->modelbasic->getTrendingEventData();
		$data['jobs']=array();
		if(($FRONT_USER_SESSION_ID > 0) || $FRONT_USER_SESSION_ID == 0){
			$data['jobs']=$this->modelbasic->getValues('company_RFP','company_RFP.id,company_RFP.description,company_RFP.rate,company_RFP.name,company_RFP.start_date,company_RFP.end_date,company_RFP.profile_image,company_RFP.duration',array('company_RFP.status'=>1),'result_array','','',array('company_RFP.created','DESC'),3);
		}
		$data['userRFP']=array();
		if(($FRONT_USER_SESSION_ID > 0) || $FRONT_USER_SESSION_ID == 0){
			$data['userRFP']=$this->modelbasic->getValues('company_RFP','company_RFP.id,company_RFP.description,company_RFP.rate,company_RFP.name,company_RFP.start_date,company_RFP.end_date,company_RFP.profile_image,company_RFP.duration',array('company_RFP.status'=>1,'company_RFP.userId'=>$this->session->userdata('front_user_id')),'result_array','','',array('company_RFP.created','DESC'),3);
		}
		$data['assignment']=$this->community_project_model->edit_assignment_data($assignment_id);
		$data['teacher']=$this->model_basic->getAllData('users','id,instituteId,firstName,lastName,email,profileImage',array('id'=>$data['assignment'][0]['user_id']));
		$data['project']=$this->community_project_model->getAllAssignmentData($assignment_id,'',$this->session->userdata('front_user_id'));	
		$data['my_project']=$this->community_project_model->getAllAssignmentData($assignment_id,$this->session->userdata('front_user_id'));
		if($sub_assig != '')
		{
			$data['sub_assig']=$sub_assig;
		}

		$data['tools']=$this->db->select('A.*,B.attributeValue')->from('assignment_tools_relation as A')->join('attribute_value_master as B','B.id = A.attribute_tools_id')->where('A.assignment_id',$assignment_id)->get()->result_array();

		$data['features']=$this->db->select('A.*,B.attributeValue')->from('assignment_features_relation as A')->join('attribute_value_master as B','B.id = A.attribute_features_id')->where('A.assignment_id',$assignment_id)->get()->result_array();

		
		$this->load->view('community_project_view',$data);		
	}

	public function more_data()
	{		
		if(isset($_POST['call_count']) && $_POST['call_count']!=''&& isset($_POST['assignment']) && $_POST['assignment']!='')
		{
			$assignment='';
			$data['assignment']=$this->assignment_model->getAssignmentData($_POST['assignment']);
			if(!empty($data['assignment']))
			{
				$assignment=$data['assignment'][0]['id'];
			}
	    	//$per_call_deal =2;
	    	$per_call_deal =12;
			$call_count = $_POST['call_count'];
			$this->assignment_model->more_data($per_call_deal,$call_count,$assignment);
		}
	}	

	public function assignment_approval($id,$status,$userId)
	{
		//echo "assignment_approval_student_coment";die;
		$commentedUserId = $_POST['assignmentCommentByUserId'];
		$commentedUserData=$this->model_basic->get_where('users',array('id'=>$commentedUserId));		
		$name = $commentedUserData['firstName'].' '.$commentedUserData['lastName'];
		$email = $commentedUserData['email'];
		$comment = $_POST['assignmentText'];
		$getProjectId = $this->model_basic->get_where('project_master',array('userId'=>$userId,'assignmentId'=>$id));
		$project_id=$getProjectId['id'];	
		if($status == 2)
		{		
			if($_POST['assignmentText']!='')
			{				
				$approvalData   = array(
						'name' 		=>ucwords($name),
						'email'    	=>$email,
						'comment'  	=>ucfirst($comment),
						'projectId'	=>$project_id,
						'userId'   	=>$this->session->userdata('front_user_id'),
						'created'  	=>date('Y-m-d H:i:s'),
						'status'   	=>1,
						'assignmentId'   	=>$id
					);
				
			}
			else
			{				
				$this->session->set_flashdata('fail', 'Assignment Comment is required.');
				redirect('assignment/assignment_detail/'.$id.'/'.$this->session->userdata('front_user_id'));
			}
		}
		if($status == 3 && $comment!='')
		{		
							
			$approvalData   = array(
					'name' 		=>ucwords($name),
					'email'    	=>$email,
					'comment'  	=>ucfirst($comment),
					'projectId'	=>$project_id,
					'userId'   	=>$this->session->userdata('front_user_id'),
					'created'  	=>date('Y-m-d H:i:s'),
					'status'   	=>1,
					'assignmentId'   	=>$id
				);					
		}		

		if(!empty($approvalData) && isset($approvalData))
		{
            $get_user_data=$this->model_basic->getData('users','firstName,lastName,email',array('id'=>$userId));
			$get_assignment_data=$this->model_basic->getData('assignment','*',array('id'=>$id));                
      		$get_teacher_data=$this->model_basic->getData('users','firstName,lastName,email',array('id'=>$get_assignment_data['teacher_id']));			

			if($status == 3)
			{
				$notificationEntry=array('title'=>'Assignment accepted','msg'=>'Assignment '.$get_assignment_data['assignment_name'].' has been accepted successfully by '.$get_teacher_data['firstName'].' '.$get_teacher_data['lastName'],'link'=>'assignment/assignment_detail/'.$id.'/'.$userId,'imageLink'=>'as.png','created'=>date('Y-m-d H:i:s'),'typeId'=>17,'redirectId'=>$id);
				$notificationId=$this->model_basic->_insert('header_notification_master',$notificationEntry);

				$notificationToCreUser=array('notification_id'=>$notificationId,'user_id'=>$userId);
				$this->model_basic->_insert('header_notification_user_relation',$notificationToCreUser);

				$subject = 'Your Assignment Has been Accepted';
				$message='Hello, '.$get_user_data['firstName'].' '.$get_user_data['lastName'].'<br /> Your Assignment '.$get_assignment_data['assignment_name'].' is accepted by your teacher '.$get_teacher_data['firstName'].' '.$get_teacher_data['lastName'].' <br /> Assignment Name : '.$get_assignment_data['assignment_name'].'<br /> Assignment Status : Accepted <br /> <br /> Thank You.';
				
				

					 $msg = array (
								'body' 	=> '',
								'title'	=> '',
								'aboutNotification'	=> '',
								'notificationTitle'	=> 'Assignment accepted',
								'notificationType'	=> 17,
								'notificationId'	=> $id,
								'notificationImageUrl'	=> ''          	
					          );
						$this->model_basic->sendNotification($userId,$msg);
			}
			else
			{
				$notificationEntry=array('title'=>'Assignment need more work','msg'=>'Assignment '.$get_assignment_data['assignment_name'].' has been checked and you need more work for submission','link'=>'assignment/assignment_detail/'.$id.'/'.$userId,'imageLink'=>'as.png','created'=>date('Y-m-d H:i:s'),'typeId'=>17,'redirectId'=>$id);
				$notificationId=$this->model_basic->_insert('header_notification_master',$notificationEntry);

				$notificationToCreUser=array('notification_id'=>$notificationId,'user_id'=>$userId);
				$this->model_basic->_insert('header_notification_user_relation',$notificationToCreUser);

				$subject = 'Your Assignment Has been Pending Resubmit it';
				$message='Hello, '.$get_user_data['firstName'].' '.$get_user_data['lastName'].'<br /> Your Assignment is evaluated by your teacher '.$get_teacher_data['firstName'].' '.$get_teacher_data['lastName'].' <br /> Assignment Name : '.$get_assignment_data['assignment_name'].'<br /> Assignment Status : Pending <br />Comments from teacher : '.ucfirst($comment).' <br /> Please make corrections and  resubmit before end date. <br /> Thank You.';
				
				$msg = array (
						'body' 	=> '',
						'title'	=> '',
						'aboutNotification'	=> '',
						'notificationTitle'	=> 'Assignment need more work',
						'notificationType'	=> 17,
						'notificationId'	=> $id,
						'notificationImageUrl'	=> ''          	
			          );
				$this->model_basic->sendNotification($userId,$msg);
			}
			
			$this->load->model('project_model');
			$ress = $this->project_model->add_comment($approvalData);
			$emailData = array('to'=>$get_user_data['email'],'fromEmail'=>$get_teacher_data['email'],'subject'=>$subject,'template'=>$message);		

			//print_r($emailData);die;			
			//$sendMail = $this->model_basic->sendMail($emailData);

			if($status == 3)
			{	
				$assignment_accepted_date = array('assignment_accepted_date'=>date('Y-m-d'));	
				$update_assignment_accepted_date = $this->model_basic->_update('project_master','id',$project_id,$assignment_accepted_date);
			}

		}

		$data = array('assignment_status'=>$status);
		$conditionArr = array('assignmentId'=>$id,'userId'=>$userId);
		$res=$this->model_basic->_updateWhere('project_master',$conditionArr,$data);
		if($res == 1)
		{
			if($status == 3)
			{
				$this->session->set_flashdata('success', 'Assignment accepted Successfully.');
				redirect('assignment/assignment_detail/'.$id.'/'.$this->session->userdata('front_user_id'));
			}
			else
			{
				$this->session->set_flashdata('success', 'Assignment need more Work.');
				redirect('assignment/assignment_detail/'.$id.'/'.$this->session->userdata('front_user_id'));
			}
		}
		else
		{
			$this->session->set_flashdata('fail', 'Sorry! Failed to update status.');
			redirect('assignment/assignment_detail/'.$id.'/'.$this->session->userdata('front_user_id'));
		}
	}



	public function assignment_approval_student_coment($id,$status,$userId)
	{		
		$commentedUserId = $_POST['assignmentCommentByUserId'];
		$commentedUserData=$this->model_basic->get_where('users',array('id'=>$commentedUserId));		
		$name = $commentedUserData['firstName'].' '.$commentedUserData['lastName'];
		$email = $commentedUserData['email'];
		$comment = $_POST['assignmentText'];
		$getProjectId = $this->model_basic->get_where('project_master',array('userId'=>$userId,'assignmentId'=>$id));
		$project_id=$getProjectId['id'];	
	
		if($status = 4 && $comment!='')
		{
			$approvalData   = array(
					'name' 		=>ucwords($name),
					'email'    	=>$email,
					'comment'  	=>ucfirst($comment),
					'projectId'	=>$project_id,
					'userId'   	=>$this->session->userdata('front_user_id'),
					'created'  	=>date('Y-m-d H:i:s'),
					'status'   	=>1,
					'assignmentId'   	=>$id
				);				
			$this->load->model('project_model');
			$res = $this->project_model->add_comment($approvalData);		
			if($res > 0)
			{				
				$this->session->set_flashdata('success', 'Assignment Edited Successfully.');
				redirect('assignment/assignment_detail/'.$id.'/'.$this->session->userdata('front_user_id'));		
			}
			else
			{				
				$this->session->set_flashdata('fail', 'Sorry! Failed to update status.');
				redirect('assignment/assignment_detail/'.$id.'/'.$this->session->userdata('front_user_id').'/1');
			}
		}		
		else 
		{
			redirect('assignment/assignment_detail/'.$id.'/'.$this->session->userdata('front_user_id').'/1');
		}
		
	}

	public function delete($assignment_id)
	{
		$res = $this->assignment_model->deleteAssignment($assignment_id);
		if($res)
		{			
			$this->session->set_flashdata('success', 'Assignment deleted successfully');			
		}
		else
		{
			$this->session->set_flashdata('fail', 'Fail to delete Assignment');
		}
		redirect('assignment/manage_assignment/'.$this->session->userdata('front_user_id'));
	}

	public function submited_assignment()
	{
		/*if($this->session->userdata('teachers_status') == 1)
		{
			$teacher_id=$this->session->userdata('front_user_id');
		}			
		$getAllUserAssignmentPast = $this->db->select('*')->from('assignment')->where('teacher_id',$teacher_id)->where('end_date <',date('Y-m-d'))->order_by("end_date",'desc')->get()->result_array();
		$getAllUserAssignmentFuture = $this->db->select('*')->from('assignment')->where('teacher_id',$teacher_id)->where('end_date >=',date('Y-m-d'))->order_by("end_date",'asc')->get()->result_array();
		$data['getAllUserAssignment'] = $getAllUserAssignmentFuture;
		if(!empty($getAllUserAssignmentPast))
		{
			$i =count($getAllUserAssignmentFuture);
			foreach ($getAllUserAssignmentPast as $value) {
				$data['getAllUserAssignment'][$i]=$value;
				$i++;
			}
		}	*/

		if($this->session->userdata('teachers_status') == 1)
		{
			$teacher_id=$this->session->userdata('front_user_id');
		}
		$getAllUserAssignment=$this->db->select('*')->from('community_project')->order_by("end_date",'asc')->get()->result_array();
		//print_r($getAllUserAssignment);die;
		if(!empty($getAllUserAssignment))
		{
			$data['assigned']=array();
			$data['pending']=array();
			$data['resubmitted']=array();
			$data['submitted']=array();
			$data['accepted']=array();
			foreach($getAllUserAssignment as $assignment)
			{
				//$TotalNoOfAssignedUser = $this->db->select('*')->from('user_assignment_relation')->where('assignment_id',$assignment['id'])->get()->num_rows();
				$TotalNoOfAssignmentSubmiterUser = $this->db->select('*')->from('project_master')->where('assignmentId',$assignment['id'])->get()->num_rows();
				$NoOfAssignmentSubmiterUser = $this->db->select('*')->from('project_master')->where('assignmentId',$assignment['id'])->where('assignment_status',1)->get()->num_rows();
				$NoOfAssignmentReSubmiterUser = $this->db->select('*')->from('project_master')->where('assignmentId',$assignment['id'])->where('assignment_status',4)->get()->num_rows();
				$NoOfAssignmentAcceptedUser = $this->db->select('*')->from('project_master')->where('assignmentId',$assignment['id'])->where('assignment_status',3)->get()->num_rows();
				$NoOfAssignmentPendingUser = $this->db->select('*')->from('project_master')->where('assignmentId',$assignment['id'])->where('assignment_status',2)->get()->num_rows();
		
									
					$data['submitted'][]=$assignment;
				
			}
		}
		else
		{
			$data=array();
		}
		$data['trandingPlacement']=$this->modelbasic->getValues('placement','student_name,company,position,profile_image',array('status'=>1,'featured'=>1),'result_array','','',array('featured_date','DESC'),8);
		$data['jobs']=array();
		if(($FRONT_USER_SESSION_ID > 0) || $FRONT_USER_SESSION_ID == 0){
			$data['jobs']=$this->modelbasic->getValues('jobs','jobs.id,jobs.title,jobs.companyLogo,jobs.companyName,jobs.no_of_position',array('jobs.featured'=>1,'jobs.status'=>1),'result_array','','',array('featured_date','DESC'),6);
		}
		//print_r($data);die;
		$data['submited_assignment'] = 1;			
		$this->load->view('community_projects_list_view',$data);		
	}


	



}