<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Creopoint extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('user_model');
        $this->load->model('modelbasic');
		$this->load->model('model_basic');
		$this->load->model('project_model');
        $this->load->model('competition_model');
		$this->load->library('form_validation');
		$this->load->library('image_lib');
	}

	public function index()
	{
		$this->load->view('creo_reward_point');
	}

	public function creoreward(){
		$this->load->view('reward_point');
	}
	public function redeempoint(){
		$this->load->view('redeem_point_view');
	}
	public function gamificationDetails(){
		$this->load->view('creo_gamification_details');
	}

	public function redeem_points() {
    $userId = $this->session->userdata('front_user_id');
    $pointsToRedeem = $this->input->post('rpoint');
    $getUserCreoPoint = $this->db->select_sum('point')->from('user_point_details')->where('user_id', $userId)->where('pstatus',0)->get()->row_array();
    $getUserredeemPoint = $this->db->select_sum('point')->from('user_point_details')->where('user_id', $userId)->where('pstatus',1)->get()->row_array();
    $availablePoints = $getUserCreoPoint['point'] - $getUserredeemPoint['point'];

    $today = date('Y-m-d');
    $pointsRedeemedToday = $this->db->select_sum('point')
                                    ->from('user_point_details')
                                    ->where('user_id', $userId)
                                    ->where('DATE(created)', $today)
                                    ->where('pstatus', 1) // Assuming point_type 0 represents redeemed points
                                    ->get()
                                    ->row_array()['point'];
    $pointsRedeemedToday = $pointsRedeemedToday ? $pointsRedeemedToday : 0;
    // Validate the input
    if ($pointsToRedeem > $availablePoints) {
        $this->session->set_flashdata('error', 'You do not have enough points to redeem this amount.');
        redirect('creopoint/creoreward');
    } elseif (($pointsRedeemedToday + $pointsToRedeem) > 250) {
        $this->session->set_flashdata('error', 'You cannot redeem more than 250 points in a day.');
        redirect('creopoint/creoreward');
    } elseif ($pointsToRedeem <= 0) {
        $this->session->set_flashdata('error', 'Please enter a valid amount of points to redeem.');
        redirect('creopoint/creoreward');
    }

    // Insert into user_point_details table
    $projectPointData = array(
        'user_id' => $userId,
        'point' => $pointsToRedeem,
        'point_type'=>0,
        'user_level'=>0,
        'pstatus' => 1,
        'created' => date("Y-m-d h:i:s")
    );
    
    $pointAdded = $this->model_basic->_insert('user_point_details', $projectPointData);
    
    if ($pointAdded) {
        $this->session->set_flashdata('success', 'Points redeemed successfully.');
    } else {
        $this->session->set_flashdata('error', 'There was an error redeeming your points. Please try again.');
    }

    redirect('creopoint/creoreward');
}

}
?>