<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Event extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('event_model');
		$this->load->model('model_basic');
		$this->load->library('form_validation');
	}	

    public function event_list()
	{
		$this->load->model('event_model');	
		$data['event']=$this->event_model->getAllEventData();
		$this->load->view('event_list_view',$data);
	}
	
	public function event_more_data()
	{
    	$per_call_deal = 16;
		$call_count = $_POST['call_count'];
		$this->load->model('event_model');
		$this->event_model->event_more_data($per_call_deal,$call_count);
	}
		
    public function show_event($eventId='')
	{ 
	    $this->load->model('event_model');
	    $user_id=$this->session->userdata('front_user_id');
		$logincount=$this->event_model->getlogincountstudent($user_id);
		//echo $this->db->last_query();
		 $registercount=$this->event_model->getregistercountstudent($user_id);
		//echo $this->db->last_query();
		if(isset($registercount) && !empty($registercount) && $logincount>=0)
		{
			$data['login_percentage']=($logincount/$registercount)*100;
		}
		$data['event']=$this->event_model->getSingleEvent($eventId);
		$this->load->view('event_view',$data);
	}
	public function more_data()
	{
		$per_call_deal = 4;
		$call_count = $_POST['call_count'];
		$search_term = $_POST['search_term'];
		$this->event_model->more_data($per_call_deal,$call_count,$search_term);
		
	}

	public function saveRegistration($eventId) {
    // Get the user ID from session
    $userId = $this->session->userdata('front_user_id');


if (isset($_POST['save_video_details'])) {
    $event_id = $_POST['event_id']; // Assuming this comes from POST data
    $userId = $this->session->userdata('front_user_id'); // Assuming the user is logged in

    // Insert registration data directly without using the model
    $data = array(
        'userId' => $userId,
        'eventId' => $event_id,
        'status' => 1,
        'created' => date("Y-m-d H:i:s")
    );

    // Insert into user_event_relation table
    $insertRegistration = $this->db->insert('user_event_relation', $data);

    

    


    // Add points to the user for registering for the event
    $projectPointData = array(
        'user_id' => $userId,
        'point' => 20,
        'point_type' => 4,
        'user_level' => 0,
        'pstatus' => 0,
        'created' => date("Y-m-d H:i:s")
    );

    // Insert points data
    $this->db->insert('user_point_details', $projectPointData);

    if ($insertRegistration) {
        // Fetch user details
        $registerUsersDetail = $this->db->select('*')
            ->from('users')
            ->where('id', $userId)
            ->get()
            ->row_array();

        // Fetch event details
        $eventData = $this->db->select('*')
            ->from('events')
            ->where('id', $eventId)
            ->get()
            ->row_array();

        if (!empty($registerUsersDetail)) {
            $registerUsersName = ucwords($registerUsersDetail['firstName'] . ' ' . $registerUsersDetail['lastName']);
            $registerUsersEmail = $registerUsersDetail['email'];
            $subjectTo = $registerUsersName . ' Registered to event on creonow.';
            $from = 'connectwithus@creonow.com';
            $templateFollowedBy = 'Hello <b>' . $registerUsersName . '</b>,<br /><br />Thank you for registering for our upcoming event! 
                                   The event will start as scheduled on ' . date('M j, Y', strtotime($eventData['start_date'])) . '.<br /><br />
                                   <b>Event Name:</b>' . $eventData['name'] . '<br />
                                   <b>Date:</b> ' . date('M j, Y', strtotime($eventData['start_date'])) . '<br /><br />
                                   If you have any last-minute questions or require assistance, contact us at [connectwithus@creonow.com].<br />
                                   Thanks,<br />Team creonow<br /><a href="http://www.ctestaging.creonow.com">www.ctestaging.creonow.com</a>';

            $sendEmailToRegisterUser = array(
                'to' => $registerUsersEmail,
                'subject' => $subjectTo,
                'template' => $templateFollowedBy,
                'fromEmail' => $from
            );

            // Send email
            $this->model_basic->sendSMTPMail($sendEmailToRegisterUser);
        }

        // Check if the badge with ID 7 exists for the user
        // $badgeExists = $this->db->select('id')
        //     ->from('users_badge')
        //     ->where('user_id', $userId)
        //     ->where('badge_id', 7)
        //     ->get()
        //     ->row_array();

        // if (empty($badgeExists)) {
        //     // Insert the badge for the user if it doesn't exist
        //     $userBadgeData = array(
        //         'user_id' => $userId,
        //         'badge_id' => 7,
        //         'created' => date("Y-m-d H:i:s")
        //     );

        //     $this->db->insert('users_badge', $userBadgeData);

        //     // Set a session popup for the event
        //     $this->session->set_userdata('add_event_popup', 8);
        //     $this->session->unset_userdata('add_project_popup');
        // } else {
        // 	     $this->session->set_userdata('add_event_point', 1);
        // }

        // Set a success message and redirect to the event page
        $this->session->set_flashdata('success', '<div>Your registration is complete,<br>and the event will start soon</div>');
        
    }
    
    redirect(base_url() . 'event/show_event/' . $event_id);
}
}

}
