<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Job extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('job_model');
		$this->load->model('model_basic');
		$this->load->library('upload');
		$this->load->library('image_lib');
		$this->load->library('form_validation');
		$FRONT_USER_SESSION_ID = intval($this->session->userdata('front_user_id'));
		$job_status = $this->model_basic->getValue($this->db->dbprefix('users'),"job_status"," `id` = '".$FRONT_USER_SESSION_ID."'");
		if($job_status == 0)
		{	
			if($FRONT_USER_SESSION_ID == 0)
			{
				redirect('hauth/googleLogin');
			}
			else
			{		
				$this->session->set_flashdata('error', 'You do not have access to this data.');
				redirect(base_url());
				exit();
			}
		}
	}
	public function index()
	{
		$data['jobs']=$this->job_model->getAllData();
		$data['jobsStates']=$this->job_model->getAllStates();
		//print_r($data);
		$this->load->view('job_view',$data);
	}
	public function jobDetail($id)
	{
		$applicant=$this->job_model->checkAppliedOrNot($id);		
		$applicantApproveFromAdmin=$this->job_model->checkJobAppliedApproveFromAdmin($id);	
		$applicantApproveFromHoAdmin=$this->job_model->checkJobAppliedApproveFromRAHAdmin($id);	
		$data['interview_testdata']=$this->job_model->check_interview_assignmnetdata($id);
	   // echo $this->db->last_query();
		//print_r($interview_testdata);die;
		$data['apply_status']=0;	
		$data['tempJobId'] = 0;
		if(!empty($applicantApproveFromAdmin) && $applicantApproveFromAdmin['apply_status'] == 0)
		{
			$data['apply_status']=7;	
		}
		else if(!empty($applicantApproveFromAdmin) && $applicantApproveFromAdmin['apply_status'] == 2)
		{
			$data['apply_status']= 8;
			$data['tempJobId']=$applicantApproveFromAdmin['id'];		
		}
		if(isset($applicantApproveFromHoAdmin) && !empty($applicantApproveFromHoAdmin))
		{
			$data['tempJobId']=$applicantApproveFromHoAdmin['id'];
		}

		if(!empty($applicant))
		{
			$data['apply_status']=$applicant['apply_status'];			
		}

		$userId=$this->session->userdata('front_user_id');
		$data['getstudenteducation_details']=$this->model_basic->getValueArray("users_education","id",array('user_id'=>$userId));
		$data['getstudentskill_details']=$this->model_basic->getValueArray("users_skills","id",array('user_id'=>$userId));
		$data['getstudentAge']=$this->model_basic->getData("users",'age,contactNo,dob,about_me',array('id'=>$userId));
		$data['getprojectdetails']=$this->model_basic->getData("project_master",'id,projectName',array('userId'=>$userId,'showreel'=>'1'));
		//echo $this->db->last_query();
		$data['jobs']=$this->job_model->getSingleJobData($id);
		$data['recent_jobs']=$this->job_model->getRecentJobData();
		$this->session->unset_userdata('edit_profile_jobsId');
		$this->load->view('single_job_view-Marketing',$data);
	}
	public function saveJobData()
	{
	    $id = $this->session->userdata('front_user_id');

	    if (isset($_POST['save_bid_details'])) {
	        $this->form_validation->set_rules('upload_file', 'Student profile image', 'callback_validateStudentProfile');

	        // Retrieve all form data
	        $job_id = $this->input->post('job_id');
	        $youtubeLink = $this->input->post('youtube_link');
	        $projectFileLink = $this->input->post('project_File_Link');
	        $proposalName = $this->input->post('proposal_name'); 
	        $bid = $this->input->post('bid');
	        $linkedin_link = $this->input->post('linkedin_link');
	        $cover_letter = $this->input->post('cover_letter'); 

	        // Validate data if necessary
	        if (!empty($youtubeLink) && !empty($projectFileLink) && !empty($proposalName) && !empty($bid) && !empty($linkedin_link)) {
	            // Prepare data for update/insert
	            $companyData = array(
	                'job_id' => $job_id,
	                'youtube_link' => $youtubeLink,
	                'project_file_link' => $projectFileLink,
	                'proposal_name' => $proposalName,
	                'bid' => $bid,
	                'linkedin_link' => $linkedin_link,
	                'cover_letter' => $cover_letter
	            );

	            // Check if a file was uploaded and add it to the companyData array
	            if (isset($_FILES['upload_file']) && $_FILES['upload_file']['size'] != 0) {
	                $uploadResult = $this->image_upload('upload_file', 'validateStudentProfile', '200', '200');
	                if ($uploadResult) {
	                    $companyData['pdf'] = $_POST['upload_file']['file_name']; // Store the file name in the database
	                } else {
	                    // Handle file upload failure if needed
	                    $this->session->set_flashdata('fail', 'Failed to upload profile image.');
	                    redirect(base_url() . 'job/jobDetail');
	                    return;
	                }
	            }

	            // Insert data if user_id is not found
	            $companyData['user_id'] = $id; // Include the user_id for the insert
	            $companyInsert = $this->db->insert('bids', $companyData);

	            if ($companyInsert) {
	                $this->session->set_flashdata('success', 'Bids details added successfully.');
	            } else {
	                $this->session->set_flashdata('fail', 'Failed to add bids details.');
	            }

	        } else {
	            $this->session->set_flashdata('fail', 'Please fill all the required fields.');
	        }

	        // Redirect to job details page
	        redirect(base_url() . 'job/jobDetail/' . $job_id);
	    }
	}

	function validateStudentProfile()
	{
	    return $this->image_upload('upload_file', 'validateStudentProfile', '200', '200');
	}

	function image_upload($folderName, $functionName, $width, $height)
	{
	    if (isset($_FILES[$folderName]) && $_FILES[$folderName]['size'] != 0) {
	        $upload_dir = file_upload_s3_path().'users/bids/';

	        if (!is_dir($upload_dir)) {
	            mkdir($upload_dir, 0777, TRUE);
	        }

	        $config['upload_path'] = $upload_dir;
	        $config['allowed_types'] = 'jpg|png|jpeg|pdf';
	        $config['file_name'] = 'bids' . '_' . substr(md5(rand()), 0, 7);
	        $config['max_size'] = '2000';

	        // Ensure the image dimensions are set
	        if ($folderName == 'bids') {
	            $config['maintain_ratio'] = TRUE;
	            $config['width'] = 945;
	            $config['height'] = 470;
	        }

	        $this->upload->initialize($config);

	        if (!$this->upload->do_upload($folderName)) {
	            $this->form_validation->set_message($functionName, $this->upload->display_errors());
	            return false;
	        } else {
	            $_POST[$folderName] = $this->upload->data();
	            return true;
	        }
	    }

	    if ($_POST['job_id'] == 0) {
	        return true;
	    } else {
	        $this->form_validation->set_message($functionName, 'Image required');
	        return false;
	    }
	}

	public function jobApply($id)
	{
		$data['jobs']=$this->job_model->getSingleJobData($id);
		$this->jobDetail($id);
		//$this->load->view('single_job_view',$data);
	}
	public function more_data()
	{
		$per_call_deal = 3;
		$call_count = $_POST['call_count'];
		$search_term = $_POST['search_term'];
		$this->job_model->more_search_data($per_call_deal,$call_count,$search_term);
	}
	public function getRelationdata($id)
	{
	  return	$this->job_model->getRelationdata($id);
    }
	public function uploadResume($jobId='')
	{
		$userId=$this->session->userdata('front_user_id');		
		$getstudenteducation_details=$this->model_basic->getValueArray("users_education","id",array('user_id'=>$userId));
        //echo "<pre>";print_r($getstudenteducation_details);exit();54
		$getstudentAge=$this->model_basic->getValue("users",'age'," `id` = '".$userId."'");
		//echo "<pre>";print_r($getstudentAge);exit();27
		if(empty($getstudentAge) && $getstudentAge==0 || empty($getstudenteducation_details))
		{
			$this->session->set_flashdata('error', 'Education OR age detilas are Empty.');
		}
		else
		{
			$institute_id=$this->session->userdata('user_institute_id');	
            
			$data=array('userId'=>$userId,'jobId'=>$jobId,'resume'=>'','apply_date'=>date('Y-m-d H:i:s'),'institute_id'=>$institute_id); 
         
			$res=$this->job_model->add($data);
          
			$getInstituteAdminInfo = $this->db->select('A.id,A.firstName,A.lastName,A.email')->from('users as A')->join('institute_master as B','B.adminId = A.id')->where('B.id',$institute_id)->get()->row_array();
			//$RecruiterEmailId = $this->db->select('recruiter_email_id')->from('jobs')->where('id',$jobId)->get()->row_array();	
			if($res > 0)
			{
				$emailFrom = $this->model_basic->getValueArray("settings","description",array('settings_id'=>7,'type'=>'from_email'));
				$jobDetails=$this->model_basic->get_where('jobs',array('id'=>$jobId));				
				$jobName=$jobDetails['title'];
				$userDetails=$this->model_basic->loggedInUserInfoById($this->session->userdata('front_user_id'));
				$template='Hello,<br/><br/> '.ucfirst($userDetails['firstName']).' '.ucfirst($userDetails['lastName']).' has applied for the job <b>'.$jobName.' </b><br/><br/><a href="'.base_url().'user/userDetail/'.$this->session->userdata('front_user_id').'">Click here</a> to see his portfolio.';				
				$data=array('fromEmail'=>$userDetails['email'],'to'=>$getInstituteAdminInfo['email'],'cc'=>$emailFrom,'subject'=>'Someone has applied for the job.','template'=>$template);	
				//$this->model_basic->sendMail($data);
				$notificationEditEntryAdmin=array('title'=>'Someone has applied for the job','msg'=>ucfirst($userDetails['firstName']).' '.ucfirst($userDetails['lastName']).' Has applied for job '.$jobName.' posted on CTE.','link'=>'job/jobDetail/'.$jobId,'imageLink'=>'companyLogos/thumbs/'.$jobDetails['companyLogo'],'created'=>date('Y-m-d H:i:s'),'typeId'=>1,'redirectId'=>$jobId);
				$notificationIdAdmin=$this->model_basic->_insert('header_notification_master',$notificationEditEntryAdmin);
				$insertJobNotificationAdmin = array('notification_id'=>$notificationIdAdmin,'user_id'=>$getInstituteAdminInfo['id'],'status'=>0);
				$this->model_basic->_insert('header_notification_user_relation',$insertJobNotificationAdmin);
				
				$msg = array (
					'body' 	=> '',
					'title'	=> '',
					'aboutNotification'	=> ucfirst($userDetails['firstName']).' '.ucfirst($userDetails['lastName']).' Has applied for job ',
					'notificationTitle'	=> 'Someone has applied for the job',
					'notificationType'	=> 1,
					'notificationId'	=> $jobId,
					'notificationImageUrl'	=> ''          	
		        );
				$this->model_basic->sendNotification($getInstituteAdminInfo['id'],$msg);

				$notificationEditEntryUser=array('title'=>'Successfully applied for job.(Pending Admin Approval)','msg'=>'Applied for job '.$jobName.' posted on CTE is pending admin approval','link'=>'job/jobDetail/'.$jobId,'imageLink'=>'companyLogos/thumbs/'.$jobDetails['companyLogo'],'created'=>date('Y-m-d H:i:s'),'typeId'=>1,'redirectId'=>$jobId);
				$notificationIdUser=$this->model_basic->_insert('header_notification_master',$notificationEditEntryUser);
				$insertJobNotificationUser = array('notification_id'=>$notificationIdUser,'user_id'=>$userId,'status'=>0);
				$this->model_basic->_insert('header_notification_user_relation',$insertJobNotificationUser);
				$projectPointData = array(
			        'user_id' => $userId,
			        'point' => 20,
			        'point_type'=>6,
			        'user_level'=>0,
			        'pstatus' => 0,
			        'created' => date("Y-m-d h:i:s")
			    );
			    
			    $pointAdded = $this->model_basic->_insert('user_point_details', $projectPointData);
				$templateForApplicant='Hello <b>'.ucfirst($userDetails['firstName']).' '.ucfirst($userDetails['lastName']).'</b>,<br/> You have successfully applied for the job <b>'.$jobName.' at '.$jobDetails['companyName'].'. </b><br/>Thank you! We will get back to you soon.<br /><br /><br />Thanks,<br />Team CTE<br /><a href="http://www.creosouls.com">www.creosouls.com</a>';				
				$dataApplicant=array('fromEmail'=>$emailFrom,'to'=>$userDetails['email'],'subject'=>'Successfully applied for job.(Pending Admin Approval)','template'=>$templateForApplicant);
				//$this->model_basic->sendMail($dataApplicant);
				
				$msg1 = array (
					'body' 	=> '',
					'title'	=> '',
					'aboutNotification'	=> 'You have successfully applied for the job.(Pending Admin Approval)',
					'notificationTitle'	=> 'Successfully applied for job',
					'notificationType'	=> 1,
					'notificationId'	=> $jobId,
					'notificationImageUrl'	=> ''          	
		        );
				$this->model_basic->sendNotification($userId,$msg1);

				$this->session->set_flashdata('success', ' You have successfully applied for job.');
				redirect('job/jobDetail/'.$jobId);
			}
			else
			{
				$this->session->set_flashdata('error', 'Error occurred while applying for job.');
				redirect('job/jobDetail/'.$jobId);
			}			
		}			
	}

	public function search_more_data()
	{
		$per_call_deal = 8;
		$call_count = $_POST['call_count'];
		$active_tab = $_POST['active_tab'];
		$this->job_model->search_more_data($per_call_deal,$_POST);
	}

	public function get_comment()
	{
		$id = $_POST['reject_comment_Id'];
		$data = $this->model_basic->getData('job_user_relation_admin_approval','*',array('id'=>$id),$order='',$limit='',$offset='');
		$html = '';
		if(!empty($data) && $data['comment'] != '')
		{
			$html .= $data['comment'];
		}
		echo $html;
	}

	public function get_comment1()
	{
		$id = $_POST['reject_comment_Id'];
		$data = $this->model_basic->getData('job_user_relation_rahadmin_approval','*',array('id'=>$id),$order='',$limit='',$offset='');
		$html = '';
		if(!empty($data) && $data['comment'] != '')
		{
			$html .= $data['comment'];
		}
		echo $html;
	}	

	public function get_comment2()
	{
		$id = $_POST['reject_comment_Id'];
		$data = $this->model_basic->getData('job_user_relation_rph_approval','*',array('id'=>$id),$order='',$limit='',$offset='');
		$html = '';
		if(!empty($data) && $data['comment'] != '')
		{
			$html .= $data['comment'];
		}
		echo $html;
	}

	public function states_data(){
		$per_call_deal = 3;
		$call_count = $_POST['call_count'];
		$stateId = $_POST['stateId'];
		$this->job_model->more_state_data($per_call_deal,$call_count,$stateId);
		
	}
}

