<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Stream extends CI_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('stream_model');
    $this->load->model('assignment_model'); 
    $this->load->model('model_basic');
    $this->load->model('user_model');
    $this->load->model('modelbasic');
		$this->session->unset_userdata('breadCrumb');
		$this->session->unset_userdata('breadCrumbLink');
		$this->session->set_userdata('breadCrumb','My Stream');
		$this->session->set_userdata('breadCrumbLink','stream');
	}

	public function index()
	{
		$arr = $this->followingUserId();
		$data['followingUserData']=$this->stream_model->getFollowingUserData($arr);
		$data['project']=$this->stream_model->getAllProjectData($arr);

		/*print_r($data);die;	*/
		$data['category']=$this->stream_model->getAllCategory();
        $getAllUserAssignment=$this->db->select('*')->from('community_project')->order_by("end_date",'asc')->get()->result_array();
        $data['trandingStudent']=$this->modelbasic->getValues('users','users.id as userId,institute_master.instituteName,users.firstname,users.lastname,users.profileimage,COUNT(DISTINCT project_master.id) AS project_count',array('project_master.status'=>1,'users.status'=>1,'users.admin_level'=>0,'users.instituteId !='=>1,'users.instituteId !='=>0),'result_array',array(array("institute_master","institute_master.id=users.instituteId"),array("project_master","project_master.userId=users.id")),'users.id',array('project_count','DESC'),10);
      
		if($this->session->userdata('user_institute_id') !='')
		{
			$data['job'] = $this->stream_model->getLimitedJob();
		}
		else
		{
			$data['job'] = array();
		}
		
        $user_id=$this->session->userdata('front_user_id');	
        $getAllUserAssignment= $this->assignment_model->getAllUserAssignment($user_id);
        if(!empty($getAllUserAssignment))
		{
			$data['assigned']=array();
			$data['pending']=array();
			$data['resubmitted']=array();
			$data['submitted']=array();
			$data['accepted']=array();
			foreach($getAllUserAssignment as $assignment)
			{
				$assignmentStaus=$this->model_basic->getValueArray('project_master','assignment_status',array('userId'=>$user_id,'assignmentId'=>$assignment['id']));
				if($assignmentStaus==1)
				{
					$data['submitted'][]=$assignment;
				}
				elseif($assignmentStaus==2)
				{
					$data['pending'][]=$assignment;
				}
				elseif($assignmentStaus==3)
				{
					$data['accepted'][]=$assignment;
				}
				elseif($assignmentStaus==4)
				{
					$data['resubmitted'][]=$assignment;
				}
				else
				{
					$data['assigned'][]=$assignment;
				}
			}
		}
		else
		{
			$data=array();
		}
      
		$this->load->view('stream_view',$data);
	}

	public function saveSkillsData()
{
    $valid = true;
    $id = $this->session->userdata('front_user_id');
    if(isset($_POST['save_skills']))
    {
        $skillName = $_POST['skillName'];
        $skillLevel = $_POST['skillLevel'];
        $entryDate = date('Y-m-d H:i:s');
        $result = array();
        $len = count($skillName);
        for($i = 0; $i < $len; $i++)
        {
            if($skillName[$i] != '')
            {
                $result[$i] = array($id, $skillName[$i], $skillLevel[$i], $entryDate);
            }
        }
        $arrCount = count($result);
        if($arrCount > 1)
        {
            array_filter($result);
        }
        $i = 0;
        $res = false; 
        if(!empty($result))
        {
            foreach ($result as $value)
            {
                $res = $this->model_basic->_insert('users_skills', array(
                    'user_id' => $id,
                    'skillName' => $skillName[$i],
                    'skillLevel' => $skillLevel[$i],
                    'created' => $entryDate
                ));
                $i++;
            }
        }
        if($res) 
        {
            if($i != 0)
            {
                $this->session->set_flashdata('success', 'Skills added successfully.');
            }
            else
            {
                $this->session->set_flashdata('fail', 'Failed to save skills.');
            }
        }
        else 
        {
            $this->session->set_flashdata('fail', 'Failed to save skills.');
        }
        redirect('stream'); 
    }
}


	public function followingUserId()
	{
	    $arr = '';
		$this->load->model('stream_model');
		$following_user=$this->stream_model->getAllFollowingUserId();
		if(!empty($following_user))
		{
			foreach($following_user as $row)
			{
				$arr[]=$row['followingUser'];
			}
		}

		return $arr;
	}

	public function chooseInterest()
	{

		$this->load->view("choose_interest_view");
	}
	public function add_interest()
	{
		if(isset($_POST['submit'])){

			$check = $_POST['checkall'];
			foreach ($check as $key => $value) {

			if(!empty($check)){
					$userId = $this->session->userdata('front_user_id');
					$catId = $value;
					$interestData = array(
            			  'userId' => $userId,
                          'categoryId' => $value,
                          'created' => date("Y-m-d h:i:s"),
                          'status' => 1
                        );
					$interestId = $this->model_basic->_insert('user_choose_interest',$interestData);

					$this->session->set_flashdata('success', 'Your interest saved successfully');


			}
		}

			redirect(base_url().'stream');
		}
	}

	public function addInterest()
	{

			$id = $_POST['id'];
			
					$userId = $this->session->userdata('front_user_id');
					$interestData = array(
            			  'userId' => $userId,
                          'categoryId' => $id,
                          'created' => date("Y-m-d h:i:s"),
                          'status' => 1
                        );
					$interestId = $this->model_basic->_insert('user_choose_interest',$interestData);

					if($this->db->affected_rows() > 0) {
				        echo 1;
				    } else {
				        echo 0;
				    }
	}
	public function unfollow_user($uid)
	{
		$res = $this->stream_model->unfollow_user($uid);
		if($res > 0)
		{
			$emailFrom = $this->model_basic->getValueArray("settings","description",array('settings_id'=>7,'type'=>'from_email'));
			$this->session->set_flashdata('success', 'You are now unfollowing this user.');
			$unfollowBy            = $this->model_basic->loggedInUserInfo();
			$unfollowTo            = $this->model_basic->loggedInUserInfoById($uid);
			$nameBy                = ucwords($unfollowBy['firstName'].' '.$unfollowBy['lastName']);
			$nameTo                = ucwords($unfollowTo['firstName'].' '.$unfollowTo['lastName']);
			$emailBy               = $unfollowBy['email'];
			$subjectBy             = 'You are no more following '.$nameTo.' on creosouls';
			$from                  = $emailFrom;
			$templateBy            = 'Hello<b> '.$nameBy. '</b>,<br /> You are no more following <b>'.$nameTo.'</b> on creosouls. <br /><br /><br />Thanks,<br />Team creosouls<br /><a href="http://www.creosouls.com">www.creosouls.com</a>';
			$emailDetailunfollowBy = array('to' => $emailBy,'subject'=>$subjectBy,'template' =>$templateBy,'fromEmail'=>$from);
			//$this->model_basic->sendMail($emailDetailunfollowBy);
			redirect('stream');
		}
		else
		{
			$this->session->set_flashdata('fail', 'failed to follow this user.');
			redirect('stream');
		}
	}
	public function more_data()
	{
		$arr = $this->followingUserId();
		$per_call_deal = 6;
	 	$call_count = $_POST['call_count'];
		$this->load->model('stream_model');
		$this->stream_model->more_data($per_call_deal,$call_count,$arr);
	}


	public function timeinline_more_data()
	{
		$per_call_deal = 10;
	  $timeLineArray = ''	;
	  $call_count = $_POST['sliceCount'];
	  if(isset($_POST['sortBy'])){
	  $sort = $_POST['sortBy'];
	} else{
		$sort = '';
	}

		$this->stream_model->timeline_more_data($call_count,$per_call_deal,$timeLineArray, $sort);
		//echo $this->db->last_query();exit();
	}






}


