<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Assessment_model extends CI_Model
{
	public function __construct()
	{
		parent::__construct();
	}
   	
	public function check_upcoming_quiz_for_user($uid,$group_id, $userLevelID = "")
		{

			$this->db->select('assessment_exam_master.*');
			$this->db->from('assessment_exam_master');
			$this->db->join('assessment_exam_user_relation','assessment_exam_master.id = assessment_exam_user_relation.exam_id','left');
		  $this->db->join('assessment_exam_group_relation', ' assessment_exam_master.id = assessment_exam_group_relation.exam_id','left');

      //If not general group
      if( $group_id != 64) {
        $this->db->where("(assessment_exam_group_relation.group_id='$group_id')");
        $this->db->where("(assessment_exam_user_relation.user_id='$uid' OR assessment_exam_group_relation.group_id='$group_id')");
      }
      
			$this->db->group_by('assessment_exam_master.id');
			$res=$this->db->get()->result_array();
		//echo "<pre/>"; print_r($res);die;
			if(!empty($res))
			{
				$exam=array();
				foreach($res as $re)
				{
					$exam[]=$re['id'];
				}
				$res1=array();
				$this->db->select('*');
				$this->db->from('assessment_log');
				$this->db->where('user_id',$uid);
				$log_detail=$this->db->get()->result_array();
				if(!empty($log_detail))
				{
					$exam1=array();
					foreach($log_detail as $val)
					{
						$exam1[]=$val['exam_id'];
					}
					$this->db->select('assessment_master.id as quiz_id,assessment_master.quiz_name,assessment_master.number_of_sections,assessment_master.assessment_information,assessment_master.assessment_image,assessment_exam_master.* ');
					$this->db->from('assessment_master');
					$this->db->join('assessment_exam_master','assessment_exam_master.quiz_id=assessment_master.id','left');
					$this->db->join('assessment_log','assessment_exam_master.id != assessment_log.exam_id');
					$this->db->where_in('assessment_exam_master.id',$exam);
					$this->db->where_not_in('assessment_exam_master.id',$exam1);
					$this->db->group_by('assessment_exam_master.id');
					return $this->db->get()->result_array();
				}
				else
				{
					$quiz=array();
					foreach($res as $val)
					{
						$quiz[]=$val['quiz_id'];
					}
					$this->db->select('assessment_master.id as quiz_id,assessment_master.quiz_name,assessment_master.number_of_sections,assessment_exam_master.* ');
					$this->db->from('assessment_master');
					$this->db->join('assessment_exam_master','assessment_exam_master.quiz_id=assessment_master.id');
					$this->db->where_in('assessment_master.id',$quiz);
					$this->db->where_in('assessment_exam_master.id',$exam);
					$this->db->group_by('assessment_exam_master.id');
					return $this->db->get()->result_array();
				}
			}
      
      		
		}
		public function quiz_level_data($id = "")
		{
			$this->db->select('*');
			$this->db->from('assessment_exam_master');
			$this->db->join('assessment_user_levels','assessment_exam_master.user_level_id = assessment_user_levels.id');
			$this->db->where('assessment_exam_master.id',$id);
			return $this->db->get()->result_array();
		}
		public function fetch_exam_group_data($gid)
		{
			$this->db->select('*');
			$this->db->from('assessment_exam_group_relation');
			$this->db->join('assessment_campaign_groups','assessment_exam_group_relation.group_id = assessment_campaign_groups.id');
			$this->db->where('assessment_exam_group_relation.exam_id',$gid);
          
			return $this->db->get()->result_array();
          
           // echo $this->db->last_query();die;
		}
		public function check_no_of_section($quiz_id)
	{
		$this->db->select('*');
		$this->db->from('assessment_master');
		$this->db->where('id',$quiz_id);
		return $this->db->get()->row_array();
	}
	public function get_quiz_detail($quiz_id,$no_of_section)
	{
		$this->db->select("assessment_section.*,GROUP_CONCAT(assessment_section_category_relations.category_id SEPARATOR ',') as catg",false);
		$this->db->from('assessment_section');
		$this->db->join('assessment_section_category_relations','assessment_section_category_relations.section_id=assessment_section.id');
		$this->db->where('assessment_section.quiz_id',$quiz_id);
		$this->db->limit($no_of_section);
		$this->db->group_by('assessment_section_category_relations.section_id');
		return $this->db->get()->result_array(); 
	}
	function getMultipleQuestions($id){

		$this->db->select('*');
		$this->db->from('assessment_answer_bank');
		$this->db->where('question_id',$id);
		$this->db->where('correct_answer',1);

		return $this->db->get()->result_array();

	}
		public function get_exam_time_info($quiz_id,$exam_id)
	{
		$this->db->select('duration,end_date,start_date');
		$this->db->from('assessment_exam_master');
		$this->db->where('id', $exam_id);
		$this->db->where('quiz_id', $quiz_id);
		$query= $this->db->get()->row_array(); 
		print_r($query);
		die;
	}
	public function verify_key($user_id,$exam_id,$key)
	{
	$this->db->select('id');
	$this->db->from('assessment_verification_key');
	$this->db->where('verification_key',$key);
	$this->db->where('user_id',$user_id);
	$this->db->where('exam_id',$exam_id);
	return $this->db->get()->row_array();
	}
		public function check_users_past_quiz($uid)
		{
			// $this->db->select('assessment_log.*,assessment_exam_master.exam_name');
			$this->db->select('assessment_log.*,assessment_exam_master.exam_name,assessment_exam_master.retry_attempt_flag,assessment_exam_master.retry_attempt,assessment_master.assessment_information,assessment_master.assessment_image');
			$this->db->from('assessment_log');
			$this->db->join('assessment_exam_master','assessment_log.exam_id = assessment_exam_master.id');
			$this->db->join('assessment_master','assessment_log.quiz_id = assessment_master.id',"left");
			$this->db->where('assessment_log.user_id',$uid);
			$this->db->where("(assessment_log.status=0 OR assessment_log.finish=1)");
			$this->db->group_by('assessment_exam_master.id');
			$query = $this->db->get();
	
			$data = array();
			if($query !== FALSE && $query->num_rows() > 0){
			   $data = $query->result_array();
			}
	
			return $data;
			//echo $this->db->last_query();die;
			//return $this->db->get()->result_array();
		//print_r($res);die;
		}
		public function get_allquiz_info()
		{
			$this->db->select('*');
			$this->db->from('assessment_master');
			return $this->db->get()->result_array();
		}
		public function fetch_timezone_data()
		{
			$this->db->select('*');
			$this->db->from('assessment_timezone');
			return $this->db->get()->result_array();
		}
		public function check_users_inprogress_quiz($uid)
	{
		$this->db->select('assessment_log.*,assessment_exam_master.exam_name,assessment_exam_master.end_date,assessment_exam_master.start_date,assessment_master.assessment_information,assessment_master.assessment_image');
		$this->db->from('assessment_log');
		$this->db->join('assessment_exam_master','assessment_log.exam_id = assessment_exam_master.id');
		$this->db->join('assessment_master','assessment_log.quiz_id = assessment_master.id',"left");
		$this->db->where('assessment_log.user_id',$uid);
		$this->db->where("(assessment_log.status=1 AND assessment_log.finish=0)");
		$this->db->group_by('assessment_log.exam_id');
         $query = $this->db->get();

        $data = array();
        if($query !== FALSE && $query->num_rows() > 0){
           $data = $query->result_array();
        }

        return $data;
		//echo $this->db->last_query();die;
		//return $this->db->get()->result_array();
		//echo $this->db->last_query();die;
	//print_r($res);die;
	}
	function get_previousQuizLog($table,$examID, $quizId, $userID,$mock){
		$this->db->select('*');
		$this->db->from($table);
		$this->db->where('exam_id',$examID);
		$this->db->where('quiz_id',$quizId);
		$this->db->where('user_id',$userID);
		//$this->db->where('finish',1);
		$res = $this->db->get()->result_array();
		return $res;
		}
		function previous_user_quiz_del($tablename, $where_array){

			return $this->db->delete($tablename,$where_array);
	} 
	function get_RetryQuizLog($table,$examID, $quizId, $userID,$mock){
		$this->db->select('*');
		$this->db->from($table);
		$this->db->where('exam_id',$examID);
		$this->db->where('quiz_id',$quizId);
		$this->db->where('user_id',$userID);
		$this->db->where('finish',1);
		$this->db->order_by('percentage', 'DESC');
		$this->db->limit(1);
		$res = $this->db->get()->result_array();
		return $res;
		}
	function getValue($table,$getColumn,$conditionArray='',$order_by='',$limit='')
	{
		$this->db->select($getColumn,false);
		$this->db->from($table);
		if($conditionArray!='')
		{
			$this->db->where($conditionArray);
		}
		if($order_by != '')
		{
			$this->db->order_by($order_by[0],$order_by[1]);
		}

		if($limit != '')
		{
			$this->db->limit($limit);
		} 
		$result=$this->db->get()->row();
      	//echo "<pre/>####"; print_r($this->db->last_query());
		if(!empty($result))
		{
			return $result->$getColumn;
		}
		else
		{
			return '';
		}
	}
	public function chck_is_quiz_expired($user_id,$exam_id,$quiz_id)
	{
		$this->db->select('assessment_exam_master.end_date,assessment_log.end_time');
		$this->db->from('assessment_exam_master');
		$this->db->join('assessment_log','assessment_log.exam_id=assessment_exam_master.id AND assessment_log.user_id='.$user_id.' AND assessment_log.exam_id='.$exam_id.' AND assessment_log.quiz_id='.$quiz_id,'left');
		$this->db->where('assessment_exam_master.quiz_id',$quiz_id);
		$this->db->where('assessment_exam_master.id',$exam_id);
	// $this->db->where('quiz_log.tenant_id',$tenant_id);
	return $this->db->get()->row_array();
		//echo $this->db->last_query();die;
		// print_r($res);die;
		
	}
	public function get_mock_categories($quiz_id)
	{
		$this->db->select('category_id');
		$this->db->from('assessment_mock_quiz_category_relation');
		$this->db->where('quiz_id',$quiz_id);
		return $this->db->get()->result_array();
	}
	function accessDatabase($tablename,$selectString, $mode, $data_array, $where_array, $join_array="",$limit="", $where_in="")

	{

		if($mode == 'select')

		{

			$this->db->select($selectString);

			$this->db->from($tablename);

			if(is_array($where_array) && !empty($where_array))

			{

				foreach ($where_array as $key => $value)

				{

					$this->db->where($key,$value);

				}

			}

			if(is_array($where_in) && !empty($where_in )||($where_in !=""))

			{

				foreach ($where_in as $key => $value)

				{

					$this->db->where_in($key,$value);

				}

			}



			if($limit != "")

			{

				if(count($limit)>1)

				{

					$this->db->limit($limit[0] , $limit[1]);

				}

				else

				{

					$this->db->limit($limit);

				}

			}

		}

		elseif($mode=='insert')

		{

			$this->db->insert($tablename,$data_array);

			return $this->db->insert_id();

		}

		elseif($mode=='update')

		{

			$this->db->where($where_array);

			return $this->db->update($tablename,$data_array);

		}

		elseif($mode=='delete')

		{

			return $this->db->delete($tablename,$where_array);

		}

		elseif($mode == 'like')

		{

			$this->db->select($selectString);

			$this->db->from($tablename);

			$this->db->like($where_array);

			if($join_array != '')

			{

				if(is_array($join_array) && !empty($join_array))

				{

					foreach ($join_array as $key => $value)

					{

						$this->db->or_like($key,$value);

					}

				}

			}

			if($data_array != '')

			{

				$this->db->having($data_array);

			}



		}

		elseif($mode=='orderby')

		{

			$this->db->select($selectString);

			$this->db->from($tablename);

			if(is_array($where_array) && !empty($where_array))

			{

				foreach ($where_array as $key => $value)

				{

					$this->db->where($key,$value);

				}

			}

			if(is_array($where_in) && !empty($where_in )||($where_in !=""))

			{

				foreach ($where_in as $key => $value)

				{

					$this->db->where_in($key,$value);

				}

			}

			$this->db->order_by($data_array[0], $data_array[1]);



		}

		elseif($mode=='groupby')

		{

			$this->db->select($selectString);

			$this->db->from($tablename);

			if(is_array($where_array) && !empty($where_array))

			{

				foreach ($where_array as $key => $value)

				{

					$this->db->where($key,$value);

				}

			}

			if(is_array($where_in) && !empty($where_in )||($where_in !=""))

			{

				foreach ($where_in as $key => $value)

				{

					$this->db->where_in($key,$value);

				}

			}

			$this->db->group_by($data_array);



		}

		elseif($mode=='join_order_limit' || $mode=='join_group_limit' || $mode=='join_group_order_limit')

		{

			$this->db->select($selectString);

			$this->db->from($tablename);

			if(is_array($join_array) && !empty($join_array))

			{

				foreach ($join_array as $value)

				{

					$this->db->join($value[0],$value[1],'left');

				}

			}

			if(is_array($where_array) && !empty($where_array))

			{

				$this->db->where($where_array);

			}

			if(is_array($where_in) && !empty($where_in )||($where_in !=""))

			{

				foreach ($where_in as $key => $value)

				{

					$this->db->where_in($key,$value);

				}

			}

			if($mode=='join_order_limit' && $data_array != '')

			{

				$this->db->order_by($data_array[0], $data_array[1]);

			}



			if($mode=='join_group_limit' && $data_array != '')

			{

				$this->db->group_by($data_array);

			}



			if($mode=='join_group_order_limit' && $data_array != '')

			{

				$this->db->order_by($data_array[0], $data_array[1]);

				$this->db->group_by($data_array[2]);

			}



			if($limit != "")

			{

				if(count($limit)>1)

				{

					$this->db->limit($limit[0] , $limit[1]);

				}

				else

				{

					$this->db->limit($limit);

				}

			}

			// echo "#####<pre/>"; print_r($this->db->last_query());

		}

		elseif($mode == 'select_like')

		{

			$this->db->select($selectString);

			$this->db->from($tablename);

			if(is_array($where_array) && !empty($where_array))

			{

				foreach ($where_array as $key => $value)

				{

					$this->db->where($key,$value);

				}

			}

			if(is_array($where_in) && !empty($where_in )||($where_in !=""))

			{

				foreach ($where_in as $key => $value)

				{

					$this->db->where_in($key,$value);

				}

			}

			 $this->db->like($data_array);

		}
      //echo "<pre/>@@@@@@@@@"; print_r($this->db->last_query());
		return $this->db->get();

	}
	public function getSectionName($quiz_id,$question_id)
	{
		return $this->db->select('A.section_name')->from('assessment_section as A')->join('assessment_section_category_relations as B','A.id=B.section_id')->join('assessment_question_category_relations as C','C.category_id=B.category_id')->where('C.question_id',$question_id)->where('A.quiz_id',$quiz_id)->group_by('A.id')->get()->row_array();
	}
	public function get_question_position($user_id,$exam_id,$quiz_id,$qid,$mock)
	{
		$this->db->select('id');
		$this->db->from('assessment');
		$this->db->where('user_id',$user_id);
		$this->db->where('exam_id',$exam_id);
		$this->db->where('quiz_id',$quiz_id);
		$this->db->where('mock',$mock);
		$this->db->where('question_id',$qid);
	return $this->db->get()->row_array();
	}
	public function check_exam_log($data,$mock)
	{
		if($mock==1)
		{
			$this->db->select('id,start_time,end_time,status');
			$this->db->from('assessment_mock_log');
			$this->db->where($data);
			return $this->db->get()->row_array();
		}
		else
		{
			$this->db->select('id,start_time,end_time,status');
			$this->db->from('assessment_log');
			$this->db->where($data);
			return $this->db->get()->row_array();
		}
	}
	public function save_log_info($data,$mock)
	{ 
		if($mock==1)
		{
			$this->db->insert('assessment_mock_log',$data);
			return $this->db->insert_id();
		}else
		{echo "niki123"; print_r($data); 
			print_r($this->db->insert('assessment_log',$data));
			 //print_r($this->db->insert_id());
			 die;
		}
	}
	public function remove_key($user_id,$exam_id,$mock)
	{
		if($mock==0)
		{
			$this->db->where('user_id',$user_id);
			$this->db->where('exam_id',$exam_id);
			return $this->db->update('assessment_verification_key',array('verification_key'=>''));
		}
	}
	public function update_user_exam_status($id,$mock,$uid,$q_id,$e_id)
	{
		if($mock==1)
		{
			$this->db->where('user_id',$uid);
			$this->db->where('quiz_id',$q_id);
			$this->db->where('exam_id',$e_id);
			$this->db->where('mock',1);
			$res=$this->db->update('assessment',array('selected_answer'=> 0 ));
			$this->db->where('id',$id);
			return $this->db->update('assessment_mock_log',array('status'=> 0 ));
		}
		else
		{
			$this->db->where('id',$id);
			return $this->db->update('assessment_log',array('status'=> 0 ));
		}
	}
	public function check_exam_master_info($id,$quiz_id)
	{
		$this->db->select('*');
		$this->db->from('assessment_exam_master');
		$this->db->where('id',$id);
		$this->db->where('quiz_id',$quiz_id);
		return $this->db->get()->row_array();
	}
	public function no_of_question($data)
	{
		$this->db->select('COUNT(*) as cnt');
		$this->db->from('assessment');
		$this->db->where($data);
		return $this->db->get()->row_array();
	}
	public function attempt_que($data)
	{
		$this->db->select('COUNT(*) as cnt');
		$this->db->from('assessment');
		$this->db->where($data);
		$this->db->where('selected_answer !=',0);
		return $this->db->get()->row_array();
	}
	public function correct_ans($data)
	{
		$this->db->select('COUNT(*) as cnt');
		$this->db->from('assessment');
		$this->db->where($data);
		//$this->db->where('selected_answer = correct_answer_opt_id');
			$this->db->where('is_correct',1);

		return $this->db->get()->row_array();
	}
	public function got_marks($data)
	{
		$this->db->select('SUM(marks) as cnt');
		$this->db->from('assessment');
		$this->db->where($data);
		//$this->db->where('selected_answer = correct_answer_opt_id');
		$this->db->where('is_correct',1);

		return $this->db->get()->row_array();
	}
	public function total_marks($data)
	{
		$this->db->select('SUM(marks) as cnt');
		$this->db->from('assessment');
		$this->db->where($data);
		return $this->db->get()->row_array();
	}
	public function update_exam_summary_in_quiz_log($condition,$data,$mock)
	{
		if($mock==0)
		{
			$this->db->where($condition);
			$this->db->update('assessment_log', $data);
		}
	}
	function getValEmailTemp($table,$getColumn,$conditionArray)
	{
		$this->db->select($getColumn);
		$this->db->from($table);
		if(is_array($conditionArray) && !empty($conditionArray))
		{
			foreach ($conditionArray as $key => $value)
			{
				$this->db->where($key,$value);
			}
		}
		return $this->db->get()->row_array();
	}
	public function get_user_profile_info($id)
	{
		$this->db->select('*');
		$this->db->from('users');
		$this->db->where('id', $id);
		return $this->db->get()->row_array();
	}
	function getGroupInfo($examID)
	{
		$this->db->select('*');
		$this->db->from('assessment_exam_group_relation');
		$this->db->where('exam_id',$examID);
		return $this->db->get()->result_array();

	}
	function getMultipleOptionIdsQuestions($id){

		$this->db->select('option_id');

		$this->db->from('assessment_answer_bank');
		$this->db->where('question_id',$id);
		$this->db->where('correct_answer',1);

		return $this->db->get()->result_array();

	}
	public function manually_end_quiz($uid,$quiz_id,$exam_id,$mock,$current_date, $completed_in)
	{
		if($mock==1)
		{
			$this->db->where('user_id',$uid);
			$this->db->where('quiz_id',$quiz_id);
			$this->db->where('exam_id',$exam_id);
			$this->db->where('mock',1);
			$res=$this->db->update('assessment',array('selected_answer'=> 0));

			$this->db->where('user_id',$uid);
			$this->db->where('quiz_id',$exam_id);
			$this->db->where('exam_id',$exam_id);
			return $this->db->update('assessment_mock_log',array('status'=> 0 ,'finish'=>1 , 'end_time'=>$current_date));
		}else
		{
			$this->db->where('user_id',$uid);
			$this->db->where('quiz_id',$quiz_id);
			$this->db->where('exam_id',$exam_id);
			return $this->db->update('assessment_log',array('status'=>0,'finish'=>1,'end_time'=>$current_date, 'total_exam_completed_in' => $completed_in));
		}
	}
	function _update_custom($table,$condition, $data)

	{

		$this->db->where($condition);

		return $this->db->update($table, $data);

	}
	public function getSelectedData($table,$selectString,$conditionArray='',$orderBy='',$dir='',$groupBy='',$limit='',$offset='',$resultMethod='')

	{

		$this->db->select($selectString);

		$this->db->from($table);

		if(is_array($conditionArray) && !empty($conditionArray))

		{

			foreach ($conditionArray as $key => $value)

			{

				$this->db->where($key,$value);

			}

		}



		if($limit != '')

		{

			$this->db->limit($limit);

		}



		if($offset != '')

		{

			$this->db->offset($offset);

		}



		if($orderBy != '')

		{

			$this->db->order_by($orderBy,$dir);

		}



		if($groupBy != '')

		{

			$this->db->group_by($groupBy);

		}



		if($resultMethod != '')

		{

			if($resultMethod == 'row')

			{

				return $this->db->get()->row();

			}

			elseif ($resultMethod == 'row_array')

			{

				return $this->db->get()->row_array();

			}



		}

		else

		{

			return $this->db->get()->result_array();

		}



	}
	public function chck_is_quizlog_time_expired($uid)
	{
		if($this->session->userdata('user_timezone')!='')
		{
			//	echo $this->session->userdata('user_timezone');
		$timezone=$this->session->userdata('user_timezone');
		}else
		{
			//echo "hii";
		$timezone='';
		}
		if($timezone=='')
		{
			//echo "ggf";
			$timezone="Asia/Calcutta";
		}
		//echo $timezone;die;
		$format = 'Y-m-d h:i a';
		$current = new DateTime(date('Y-m-d H:i:s'), new DateTimeZone($timezone));
		$current->setTimeZone(new DateTimeZone('UTC'));
		$current_date=$current->format($format);
		$this->db->select('*');
		$this->db->from('assessment_log');
		$this->db->where('user_id',$uid);
		$res=$this->db->get()->result_array();
		if(!empty($res))
		{
			foreach ($res as $val) {
				if(strtotime($current_date)>strtotime($val['end_time']))
				{
					$this->db->where('user_id',$uid);
					$this->db->where('quiz_id',$val['quiz_id']);
					$this->db->where('exam_id',$val['exam_id']);
					$this->db->update('assessment_log',array('status'=>0));
				}
			}
		}
	}

}