<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Event_model extends CI_Model
{
	public function __construct()
	{
		parent::__construct();
	}
	
		
	public function markExpiredEvents()
	{
		$this->db->select('*');
		$this->db->from('events');
		$this->db->where('status',1);
	    $det = $this->db->get()->result_array();
	    
	    foreach($det as $val)
		{
		  if(date("Y-m-d H:i:s") > date("Y-m-d 23:59:59",strtotime($val['end_date'])))
			{
				$this->db->where('id',$val['id']);
				$this->db->update('events',array('status'=>2));
			}
		}
    }
	
	
	public function getAllEventData()
	{
		$this->markExpiredEvents();		
		$this->db->select('*');
		$this->db->from('events');
		$this->db->limit(16);
		$this->db->where('status', 1);
		// $this->db->where('status !=',0);
		$this->db->order_by('created','desc');
	    return $this->db->get()->result_array();
    }

    public function getAllEventDatas($user_id = null)
	{
	    $this->markExpiredEvents(); // Assuming this is necessary
	    
	    $this->db->select('*');
	    $this->db->from('events');
	    $this->db->limit(16);
	    $this->db->where('status !=', 0); // Fetch only active events

	    // Filter events by user ID if provided
	    if ($user_id !== null) {
	        $this->db->where('userId', $user_id); // Assuming 'userId' is the correct column for the user's ID
	    }

	    $this->db->order_by('created', 'desc'); // Order by creation date
	    return $this->db->get()->result_array(); // Return result as an array
	}

	public function getAllPlacementDatas($user_id = null)
	{
	    
	    $this->db->select('*');
	    $this->db->from('placement');
	    $this->db->limit(16);
	    $this->db->where('status !=', 0); // Fetch only active events

	    // Filter events by user ID if provided
	    if ($user_id !== null) {
	        $this->db->where('user_id', $user_id); // Assuming 'userId' is the correct column for the user's ID
	    }

	    $this->db->order_by('created', 'desc'); // Order by creation date
	    return $this->db->get()->result_array(); // Return result as an array
	}

	public function getAllJobsDatas($user_id = null)
	{

	    
	    $this->db->select('*');
	    $this->db->from('jobs');
	    $this->db->limit(6);
	    $this->db->where('status !=', 0); // Fetch only active events

	    // Filter events by user ID if provided
	    if ($user_id !== null) {
	        $this->db->where('posted_by', $user_id); // Assuming 'userId' is the correct column for the user's ID
	    }

	    $this->db->order_by('created', 'desc'); // Order by creation date
	    return $this->db->get()->result_array(); // Return result as an array
	}

	public function getAllRFPsDatas($user_id = null)
	{

	    
	    $this->db->select('*');
	    $this->db->from('company_RFP');
	    $this->db->limit(6);
	    $this->db->where('status !=', 0); // Fetch only active events

	    // Filter events by user ID if provided
	    if ($user_id !== null) {
	        $this->db->where('userId', $user_id); // Assuming 'userId' is the correct column for the user's ID
	    }

	    $this->db->order_by('created', 'desc'); // Order by creation date
	    return $this->db->get()->result_array(); // Return result as an array
	}

	public function getAllcompanyData($user_id = null)
	{

	    
	    $this->db->select('*');
	    $this->db->from('company');

	    // Filter events by user ID if provided
	    if ($user_id !== null) {
	        $this->db->where('user_id', $user_id); // Assuming 'userId' is the correct column for the user's ID
	    }

	    $this->db->order_by('created', 'desc'); // Order by creation date
	    return $this->db->get()->result_array(); // Return result as an array
	}


	
	public function event_more_data($limit,$page)
	{
		//$this->markExpiredEvents();	
	  	$start=($page-1)*$limit;
		$this->db->select('*');
		$this->db->from('events');
		$this->db->limit($limit);
		$this->db->offset($start);
		$this->db->where('status !=',0);
		$this->db->order_by('created','desc');
	    $data = $this->db->get()->result_array();
		
	   if(!empty($data))
		{ 
		    $i=0;
			foreach($data as $row)
			{
				$data[$i]['end_date'] = date("F j, Y",strtotime($row['end_date']));
				$data[$i]['start_date'] = date("F j, Y",strtotime($row['start_date']));

			}
		   $i++;	
		   echo json_encode($data);
	    }
	    else
	    {
	     	echo '';
	    }
	}
	
	
	public function getSingleEvent($eventId)
	{
		$this->markExpiredEvents();
		
		$this->db->select('*');
		$this->db->from('events');
		$this->db->where('id',$eventId);
		$this->db->where('status !=',0);
	    return $this->db->get()->result_array();
    }

    public function getlogincountstudent($user_id)
    {
		$this->db->select('count(*) As logincount');
		$this->db->from('institute_csv_users icu');
		$this->db->join('student_membership sm', 'icu.id = sm.csvuserId');
		$this->db->join('institute_master im', 'icu.instituteId = im.id');
		$this->db->where('im.adminId',$user_id);		
		$this->db->where('icu.centerId',1);
		$this->db->where('im.status',1);
		$this->db->where('icu.studentId !=',' ',true);
		$this->db->where('icu.email != ',' ',true);
		$query=$this->db->get();
		if($query->num_rows()== 1)
		{			
			return $query->row()->logincount;
		}
		else
		{
			return false;
		}	
    }


    public function getregistercountstudent($user_id)
    {
		$this->db->select('count(*) As registercount');
		$this->db->from('institute_csv_users icu');
		$this->db->join('student_membership sm', 'icu.id = sm.csvuserId');
		$this->db->join('institute_master im', 'icu.instituteId = im.id');
		$this->db->where('icu.centerId',1);
		$this->db->where('im.adminId',$user_id);
		$this->db->where('im.status',1);
		$this->db->where('icu.studentId !=',' ',true);
		$query=$this->db->get();
		if($query->num_rows()== 1)
		{			
			return $query->row()->registercount;
		}
		else
		{
			return false;
		}	
    }

    public function more_data($limit,$page,$search_term)
	{
	 	$start=($page-1)*$limit;
		$this->db->select('*');
		$this->db->from('events');
		$this->db->where('status !=',0);
		if($search_term != '')
		{
			$this->db->where("(description LIKE '%".$search_term."%'|| name LIKE '%".$search_term."%')");
		}
		$this->db->limit(16);
		$this->db->offset($start);
		$this->db->order_by('created','desc');
	    $data = $this->db->get()->result_array();
	    //echo $this->db->last_query();exit();
	   if(!empty($data))
		{
			$i = 0; 
			foreach($data as $row)
			{
				$data[$i]['created'] = date("F j, Y", strtotime($row['created']));
				$item = array();
				$this->db->select('ue.eventId,ue.userId,users.firstName,users.lastName,users.profileImage');
	    		$this->db->from('user_event_relation ue');
				$this->db->where('ue.eventId',$row['id']);
				$this->db->order_by('ue.created','desc');
				$this->db->join('users', 'users.id = ue.userId');
				$registerUser = $this->db->get()->result_array();
				$registerCount = count($registerUser);
                if($registerCount > 2){
                    $newRegCount = $registerCount - 2;
                }else{
                    $newRegCount = $registerCount;
                }
				$counter = 0;
                $max = 2;
				foreach ($registerUser as $key => $value) {
					array_push($item, $value['firstName']);
                    $counter++;
                    if ($counter === $max) {
                        break;
                    }
                }
                $regUser = implode(', ', $item);
                $data[$i]['registerUser'] = $regUser;
                $data[$i]['registerCount'] = $newRegCount;	
				$i++;
			}
			
		 	echo json_encode($data);
	    }
	    else
	    {
	     	echo '';
	    }
	}
	public function addRegistrationData($userId,$eventId)
	{
		$data = array('userId'=>$userId,'eventId'=>$eventId,'status'=>1,'created'=>date("Y-m-d H:i:s"));
	    return $this->db->insert('user_event_relation',$data);
	}

	public function getEventRegisterUser($userId,$eventId)
	{
		$this->db->select('ue.eventId,ue.userId,users.firstName,users.lastName,users.profileImage');
	    $this->db->from('user_event_relation ue');
		$this->db->where('ue.eventId',$eventId);
		$this->db->order_by('ue.created','desc');
		$this->db->join('users', 'users.id = ue.userId');
		return $this->db->get()->result_array();
	}
}