# How to become a contributor and submit your own code
## Contributor License Agreements
We'd love to accept your code patches! However, before we can take them, we have to jump a couple of legal hurdles.
Please fill out either the individual or corporate Contributor License Agreement (CLA).
  * If you are an individual writing original source code and you're sure you own the intellectual property, then you'll need to sign an [individual CLA](http://code.google.com/legal/individual-cla-v1.0.html).
  * If you work for a company that wants to allow you to contribute your work to this client library, then you'll need to sign a[corporate CLA](http://code.google.com/legal/corporate-cla-v1.0.html).
Follow either of the two links above to access the appropriate CLA and instructions for how to sign and return it. Once we receive it, we'll add you to the official list of contributors and be able to accept your patches.
## Submitting Patches
1. Fork the PHP client library on GitHub
1. Decide which code you want to submit. A submission should be a set of changes that addresses one issue in the issue tracker. Please file one change per issue, and address one issue per change. If you want to make a change that doesn't have a corresponding issue in the issue tracker, please file a new ticket!
1. Ensure that your code adheres to standard PHP conventions, as used in the rest of the library.
1. Ensure that there are unit tests for your code.
1. Sign a Contributor License Agreement (see above).
1. Submit a pull request with your patch on Github.
