<?php

if (!defined('BASEPATH'))

exit('No direct script access allowed');

class assessment_level extends MY_Controller

{

	function __construct()
	{
		parent::__construct();
		// $this->load->library('upload');
		// $this->load->library('image_lib');
		// $this->load->helper('imgupload');
		$this->load->library('form_validation');
		$this->load->model('modelbasic');
		$this->load->model('admin/assessment_model');
		
	}

	public function index()
	{
		//$data['users']=$this->modelbasic->getAllWhere('users','*');
		//echo '<pre>'; print_r($this->session->all_userdata()); exit;
		$data['page_name']='assessment_level/assessment_level';
		$this->load->view('admin/assessment/assessment_level/assessment_level_view',$data);
	}

	public function getAjaxdataObjects()
	{
		$timezone='Asia/Kolkata';
		if($this->session->userdata('time_zone')!='')
		{
		    $timezone=$this->session->userdata('time_zone');
		}
		$tz_from = 'UTC';
		$tz_to = $timezone;
		$format = 'M d,Y H:i:s';
		$_POST['columns']='id,level_name,status,created';
		$requestData = $_REQUEST;
		// print_r($_REQUEST); die();
		$columns=explode(',',$_POST['columns']);
		$selectColumns = "id,level_name,status,created";
		// $condition=array('tenant_id'=>$this->session->userdata('tenant_id'));
		$condition= "";
		// if($this->session->userdata('tenant_id') != '1' && ($this->session->userdata('admin_level') != '1'))
	    // {
	    //   $condition=array('tenant_id'=>$this->session->userdata('tenant_id'));
	    // }
		$totalData=$this->modelbasic->count_all_only('assessment_level',$condition);
		$totalFiltered=$totalData;
		//$join_array=array(array('tenant as B','B.id=A.tenant_id'));
		// $result=$this->modelbasic->run_query('manage_groups AS A',$requestData,$columns,$selectColumns,'','',$condition,$join_array);
		$result=$this->modelbasic->run_query('assessment_level',$requestData,$columns,$selectColumns,'','',$condition);
		//$result=$this->modelbasic->getAllWhere('manage_groups','*',$condition);
		if( !empty($requestData['search']['value']) )
		{

			$totalFiltered=count($result);

		}

		$data = array();

		if(!empty($result))

		{

			$i=1;

			foreach ($result as $row)

			{

				$nestedData=array();

				switch ($row["status"]) {

				case 1 : $status='<span class="label label-success" onclick="change_status('.$row["id"].',1)" data-toggle="modal" style="cursor: pointer;">Active</span>'; break;

					case 0 : $status='<span class="label label-danger" onclick="change_status('.$row["id"].',0)" data-toggle="modal" style="cursor: pointer;">Deactive</span>'; break;

				default : $status=''; break;

				}

				// $nestedData['chk'] = '<div class="vd_checkbox checkbox-success"><input type="checkbox" class="case" id="check-'.$row["id"].'" name="checkall['.$row["id"].']" data-index="'.$row["id"].'"><label for="check-'.$row["id"].'"> </label></div>';
				$nestedData['chk'] = '<input type="checkbox" class="case" id="check" name="checkall['.$row["id"].']" data-index="'.$row["id"].'">';
				$nestedData['id'] =$i+$requestData['start'];
				$nestedData['level_name'] =ucwords($row["level_name"]);
				$nestedData['status'] =$status;
				//$nestedData['signup_show'] =($row["signup_show"])?'Yes':'No';
			    $start = new DateTime($row["created"], new DateTimeZone($tz_from));
			    $start->setTimeZone(new DateTimeZone($tz_to));
			    $created=$start->format($format);

			    $nestedData['created'] =$created;

			//	$nestedData['created'] = $createdDateVal->format('M d,Y H:i:s');

				$nestedData['action'] = '<div class="menu-action">

							<a onclick="edit_group('.$row['id'].');" class="btn menu-icon vd_bd-yellow vd_yellow" data-placement="top" data-toggle="tooltip" data-original-title="edit"> <i class="fa fa-pencil"></i> </a>

							<a onclick="delete_confirm('.$row['id'].');" class="btn menu-icon vd_bd-red vd_red" data-placement="top" data-toggle="tooltip" data-original-title="Delete"> <i class="fa fa-times"></i> </a></div>';

							$data[] = $nestedData;

							$i++;

						}

					}

					$json_data = array(

							"draw"            => intval( $requestData['draw'] ),

							"recordsTotal"    => intval( $totalData ),  // total number of records

							"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData

							"data"            => $data   // total data array

							);
							echo json_encode($json_data);

		}


	public function delete_confirm($id)
	{
		$res=$this->modelbasic->_delete('assessment_level',$id);
		if($res ==1)
		  {
		  	$this->session->set_flashdata('success', 'Level deleted successfully');
		  	redirect('admin/assessment_level');
	      }
		  else
		  {
		  	$this->session->set_flashdata('error', 'Fail to delete Level');
		  	redirect('admin/assessment_level');
		  }
	}

	public function change_status($id)
	{
			$result = $this->modelbasic->getValue('assessment_level','status','id',$id);
			if($result == 1)
			{
					$data = array('status'=>0);
					$this->session->set_flashdata('success', 'Level deactivated successfully.');

			}else if($result == 0)
			{
				$data = array('status'=>1);
				$this->session->set_flashdata('success', 'Level activated successfully.');
			}
			$this->modelbasic->_update('assessment_level',$id, $data);
			redirect('admin/assessment_level');
	}

	public function add()
	{
		
		$id=$this->input->post('id',TRUE);
		$this->form_validation->set_error_delimiters('<div class="error">', '</div>');
		$this->form_validation->set_rules('level_name','level_name','trim|required');
	//	$this->form_validation->set_rules('signup_show','signup_show','trim|required');
	// $this->input->post('signup_show',TRUE)
		if ($this->form_validation->run())
		{
			if($id !='')
			{
				$data=array('level_name'=>$this->input->post('level_name',TRUE),'created'=>date('Y-m-d H:i:s'));
				$res=$this->modelbasic->_update('assessment_level',$id,$data);
				if($res==1)
				{
					$data=array('status'=>'success','for'=>'add','message'=>'Level updated successfully.');
				}
				else
				{
					$data=array('status'=>'error','message'=>'Error occurred while updating Level please try again...');
				}
				echo json_encode($data);
			}
			else
			{
				$data=array('level_name'=>$this->input->post('level_name',TRUE),'created'=>date('Y-m-d H:i:s'));
				$res=$this->modelbasic->_insert('assessment_level',$data);
				if($res > 0)
				{

					$data=array('status'=>'success','for'=>'add','message'=>'Level added successfully.');
				}
				else
				{
					$data=array('status'=>'error','message'=>'Error occurred while adding Level please try again...');
				}
				echo json_encode($data);
			}		
		}
		else
		{
			if($this->input->is_ajax_request())
			{
				echo $this->form_validation->get_json();
			}
			else
			{
				$data=array('status'=>'error','message'=>'Error occurred while adding Level please try again...');
				echo json_encode($data);
			}
		}
	}

	public function edit_group($id)
	{	
		$data=$this->assessment_model->get_single_level($id);	
		echo json_encode($data);		
	}
	
	function multiselect_action()

		{

			if(isset($_POST['submit']))

			{

				$check = $_POST['checkall'];

				foreach($check as $key => $value)

				{

					if($_POST['listaction'] == '1')

					{

						$status = array('status'=>'1');

						$this->modelbasic->_update('assessment_level',$key,$status);

						$this->session->set_flashdata('success', 'Level activated successfully');

					}

					elseif($_POST['listaction'] == '2')

					{

							$status = array('status'=>'0');

							$this->modelbasic->_update('assessment_level',$key,$status);

							$this->session->set_flashdata('success', 'Level deactivated successfully');

					}

					elseif($_POST['listaction'] == '3'){

						$this->modelbasic->_delete('assessment_level',$key);

						$this->session->set_flashdata('success', 'Level deleted successfully');

					}

				}

				redirect('admin/assessment_level');

			}

		}

	}

