<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Webinar extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('webinar_model');
		$this->load->model('modelbasic');
		$this->load->library('form_validation');

	}

	public function manage_webinar()
	{
		//$this->check_session();
		$data['details']=$this->webinar_model->get_all_webinar();
      	//echo "<pre/>"; print_r($data); die;
		$this->load->view('admin/webinar/manage_webinar',$data);
	}

	public function add_webinar()
	{
		$front_user_id = $this->session->userdata('front_user_id');
      $admin_SESSION_ID = intval($this->session->userdata('admin_id'));
	    //$this->check_session();	   
	   	$this->form_validation->set_rules('webinar_title','Webinar Title','trim|required|xss_clean|callback_title_check');
	   	$this->form_validation->set_rules('description','Webinar Description','trim|xss_clean');

		$this->form_validation->set_rules('date','Date','trim|xss_clean');

		$this->form_validation->set_rules('time','Time','trim|xss_clean');

		$this->form_validation->set_rules('webinar_region','Webinar Region','trim|xss_clean');

		$this->form_validation->set_rules('webinar_speaker_detail','Webinar Speaker Detail','trim|xss_clean');

	   	$this->form_validation->set_rules('webinar_link','Website','trim|xss_clean');

		//$this->form_validation->set_rules('webinar_video','Youtube','trim|xss_clean');

	    if($this->form_validation->run())		

	   	{

			if(!is_dir('uploads/webinar'))

			{

				@mkdir('../uploads/webinar', 0777, TRUE);

			}



			if(!is_dir('uploads/webinar/thumb'))

			{

				@mkdir('../uploads/webinar/thumb', 0777, TRUE);

			}

			

		    $this->load->library('upload');

			$this->load->library('image_lib');

			$config['upload_path'] = '../uploads/webinar/';

			$config['allowed_types'] ='gif|jpg|png|img|jpeg';

			$this->upload->initialize($config);

			if($this->upload->do_upload('picture'))

			{

			    $img=$this->upload->data();

				$config['image_library'] = 'gd2';

			    $config['source_image'] = '../uploads/webinar/'.$img['file_name'];

				$config['new_image']='../uploads/webinar/thumb/'.$img['file_name'];

				$config['create_thumb'] = FALSE;

				$config['maintain_ratio'] = TRUE;

				$config['width'] = 220;

				$config['height'] = 59;
				$config['master_dim'] = 'width';
			    $this->image_lib->initialize($config);

			    if ( ! $this->image_lib->resize())

				{

				    echo $this->image_lib->display_errors();die;

				}

				$data=array('webinar_title'=>$_POST['webinar_title'],'description'=>$_POST['description'], 'date'=>date('Y-m-d', strtotime($_POST['date'])), 'time'=>date('H:i:s', strtotime($_POST['time'])), 'region'=>$_POST['webinar_region'], 'speaker_details'=>$_POST['webinar_speaker_detail'], 'registration_link'=>$_POST['webinar_link'], 'video'=>$_POST['webinar_video'], 'image'=>$img['file_name'],'created'=>date('Y-m-d H:i:s'));
				if($this->session->userdata('admin_level')==2)
				{
					// $data['userId']= $this->session->userdata('admin_id');
					if ($front_user_id) {
				        $data['userId']= $this->session->userdata('front_user_id');
				    } elseif($admin_SESSION_ID)
				    {
				    	$data['userId']= $this->session->userdata('admin_id');
				    }
					$data['instituteId']= $this->session->userdata('instituteId');
				}
				else
				{
					// $data['userId']= $this->session->userdata('admin_id');
					if ($front_user_id) {
				        $data['userId']= $this->session->userdata('front_user_id');
				    } elseif($admin_SESSION_ID)
				    {
				    	$data['userId']= $this->session->userdata('admin_id');
				    }
					$data['instituteId']= 0;
				}
				$this->load->model('webinar_model');
				//echo "<pre>";print_r($data);die;
				$res=$this->webinar_model->add($data);

                //$user=$this->modelbasic->getAllUser();
              	$user=$this->modelbasic->getAllUserwithmailNotification();
                //echo "<pre>";print_r($user);die;
                $emailFrom = $this->modelbasic->getValueArray("settings","description",array('settings_id'=>7,'type'=>'from_email'));
                foreach ($user as $val)
                {
                  $emailTo=$val['email'];
                  $from=$emailFrom;
                  //$nameTo=ucwords($val['firstName'].' '.$val['lastName']);
                  $nameTo=ucwords($val['firstName']);
                  $templateblogEmail='Hello <b>'.$nameTo. '</b>,<br />Your weekly learning dose is here. Click on the link below to attend Creo Live! Session on<br />'.$_POST['webinar_title'].'<br /><a href="'.front_base_url().'resource/detailwebinars/'.$_POST['webinar_title'].'">Click here</a><br />If you have any questions or need help, reply to us over here and we will get back to you as quickly as possible.<br />For more updates, log in to <a href="http://www.creonow.com">Creonow</a><br />Thanks,<br />Team Creonow.<br /><br />';
                  $emailblogDetail=array('to'=>$emailTo,'subject'=>'New Webinar published on Creonow','template'=>$templateblogEmail,'fromEmail'=>$from);
                  $this->modelbasic->sendMail($emailblogDetail);
                }


				if($res > 0)

		 		{
                  	
					$this->session->set_flashdata('success','Added successfully');

					redirect('admin/webinar/manage_webinar');

		 		}

	 			else

    		    {

					$this->session->set_flashdata('fail','Add Fail');

					redirect('admin/webinar/manage_webinar');

    		    }

			}

			else

    	    {

    			$error=$this->upload->display_errors();

			    $this->session->set_flashdata('error',$error);

				redirect('admin/webinar/manage_webinar');

	        }

		}

  		else

		{

		   $this->load->view('admin/webinar/add_view');

		}

	}

	public function view($id)
	{

		$this->check_session();

		$this->load->model('webinar_model');

		$data['info']=$this->webinar_model->view($id);

		$this->load->view('admin/webinar/display',$data);

    }

    public function title_check($str='',$id='')
       { 	   
       	if($id=='')
       	{	
       		$res =array('webinar_title'=>$str);	
       		$check_title=$this->modelbasic->getSelectedData('webinar','webinar_title',$res,'','','','','','row_array');	   	
    		if ($check_title['webinar_title'] != '')
    	        {		        
                   $this->form_validation->set_message('title_check', 'The Title field exist');
                   return FALSE;
    	        }
    	        else
    	        {		        	
    	           return TRUE;
    	        }
    	       
       	}
       	else
       	{   		
       		$res=array('webinar_title'=>$str,'id != '=>$id);
       		$check_title=$this->modelbasic->getSelectedData('webinar','webinar_title',$res,'','','','','','row_array');	   		
       		if ($check_title['webinar_title'] != '')
               {	           
                  $this->form_validation->set_message('title_check', 'The Title field exist');
                  return FALSE;
               }
               else
               {	                 
                  return TRUE;
               }	         
      	}
     }


	public function edit_webinar($id)

	{

        //print_r($_POST);die;

		$this->check_session();	   

	   	$this->form_validation->set_rules('webinar_title','Webinar Title','trim|required|xss_clean|callback_title_check['.$id.']');
	   	$this->form_validation->set_rules('description','Webinar Description','trim|xss_clean');

		$this->form_validation->set_rules('date','Date','trim|xss_clean');

		$this->form_validation->set_rules('time','Time','trim|xss_clean');

		$this->form_validation->set_rules('webinar_region','Webinar Region','trim|xss_clean');

		$this->form_validation->set_rules('webinar_speaker_detail','Webinar Speaker Detail','trim|xss_clean');

	   	$this->form_validation->set_rules('webinar_link','Website','trim|xss_clean');

		//$this->form_validation->set_rules('webinar_video','Youtube','trim|xss_clean');
	    if($this->form_validation->run())

	   	{

			if(!is_dir('uploads/webinar'))

			{

				@mkdir('../uploads/webinar', 0777, TRUE);

			}



			if(!is_dir('uploads/webinar/thumb'))

			{

				@mkdir('../uploads/webinar/thumb', 0777, TRUE);

			}

			//echo 'hi';die;

			$this->load->library('upload');

			$this->load->library('image_lib');

			$config['upload_path'] = '../uploads/webinar/';

			$config['allowed_types'] ='gif|jpg|png|img';

			$this->upload->initialize($config);

			if($_FILES['picture']['size']!=0)

		    {

		     	if($this->upload->do_upload('picture'))

			    {

			    	$img=$this->upload->data();

					$config['image_library'] = 'gd2';

				    $config['source_image'] = '../uploads/webinar/'.$img['file_name'];

					$config['new_image']='../uploads/webinar/thumb/'.$img['file_name'];

					$config['create_thumb'] = FALSE;

					$config['maintain_ratio'] = TRUE;

					$config['width'] = 220;
					$config['height'] = 59;
					$config['master_dim'] = 'width';

				    $this->image_lib->initialize($config);

				    if ( ! $this->image_lib->resize())

					{

					    echo $this->image_lib->display_errors();die;

					}

				}

			    else

		        {

			    	$error=$this->upload->display_errors();

					$this->session->set_flashdata('img',$error);

					redirect('admin/webinar/edit/'.$id);

	 	    	}

			}

			  	if(!isset($img))

		    	{

			 		 $data=array('webinar_title'=>$_POST['webinar_title'],'description'=>$_POST['description'], 'date'=>date('Y-m-d', strtotime($_POST['date'])), 'time'=>date('H:i:s', strtotime($_POST['time'])), 'region'=>$_POST['webinar_region'], 'speaker_details'=>$_POST['webinar_speaker_detail'], 'registration_link'=>$_POST['webinar_link'], 'video'=>$_POST['webinar_video']);

				}

		        else

		        {

				    $this->load->model('webinar_model');

					$query = $this->webinar_model->data($id);

				    if( !empty($query[0]['picture']) || ( !empty( $_FILES['picture']['name'] ) ) )

					{

			        	unlink( '../uploads/webinar/' . $query[0]['picture'] );

			        	unlink( '../uploads/webinar/thumb/' . $query[0]['picture'] );



			        }

		    		$data=array('webinar_title'=>$_POST['webinar_title'],'description'=>$_POST['description'], 'date'=>date('Y-m-d', strtotime($_POST['date'])), 'time'=>date('H:i:s', strtotime($_POST['time'])),'region'=>$_POST['webinar_region'], 'speaker_details'=>$_POST['webinar_speaker_detail'], 'registration_link'=>$_POST['webinar_link'], 'video'=>$_POST['webinar_video'], 'image'=>$img['file_name']);

		        }



		    		$this->load->model('webinar_model');

					$res=$this->webinar_model->update_user($data,$id);

					//print_r($res);die;

		  			if($res > 0)

					{

  						$this->session->set_flashdata('success','Edit successfully');

						redirect('admin/webinar/manage_webinar');

					}

	 				else

				    {

					   $this->session->set_flashdata('Fail','Edit Fail');

 						redirect('admin/webinar/manage_webinar');

				    }

		   }

  		 else

		 {

		  	$this->check_session();

			$this->load->model('webinar_model');

			$data['info']=$this->webinar_model->edit($id);
			print_r($data['info']);die;
			//$this->load->view('admin/webinar/edit_view',$data);

		 }

		 

	}

	 

	public function delete($id)

	{

	   //$this->check_session();

		$this->load->model('webinar_model');

	    $query = $this->webinar_model->view($id);

			    $path2 = '../uploads/webinar/';

		        $path3 = '../uploads/webinar/thumb/';





		        if(!empty($query[0]['picture']))

				{

		        	unlink( $path2 . $query[0]['picture'] );

		        	unlink( $path3 . $query[0]['picture'] );

              }

			$result = $this->webinar_model->delete($id);



	   if($result > 0)

	   {

	   		$this->session->set_flashdata('success','Record Deleted Successfuly');

	 	 	redirect('admin/webinar/manage_webinar');

	   }

	  else

	   {

		    $this->session->set_flashdata('fail','Failed To Delete Record');

		    redirect('admin/webinar/manage_webinar');

	   }

	}

	function change_status($id = NULL)

	{

		$query = $this->get_where($id);

		$result = $query->row();

		if($result->status == 1){

			$data = array('status'=>'0');

				$this->session->set_flashdata('success', 'webinar deactivated successfully');



		}else if($result->status == 0){

			$data = array('status'=>'1');

			$this->session->set_flashdata('success', 'webinar activated successfully');

		}



			$this->_update($id, $data);

			redirect('admin/webinar/manage_webinar');



	}

	function _update($id, $data){

		$this->webinar_model->_update($id, $data);

	}

	function get_where($id)

	{

	    $this->load->model('webinar_model');

		$query = $this->webinar_model->get_where($id);

		return $query;

	}

	function multiselect_action(){

		if(isset($_POST['submit'])){



			$check = $_POST['checkall'];



			//echo "<pre>";print_r($_POST);die;



			foreach ($check as $key => $value) {



				if($_POST['listaction'] == '1'){



					$status = array('status'=>'1');

					$this->load->model('webinar_model');

					$this->webinar_model->update_user($status,$key);



					$this->session->set_flashdata('success', 'webinar\'s activated successfully');





				}else if($_POST['listaction'] == '2'){







						$status = array('status'=>'0');

						$this->load->model('webinar_model');

					$this->webinar_model->update_user($status,$key);



						$this->session->set_flashdata('success', 'webinar\'s deactivated successfully');





				}else if($_POST['listaction'] == '3'){





						$this->load->model('webinar_model');

				 $query=$this->webinar_model->view($key);



				        $path2 = './uploads/webinar/';

				        $path3 = './uploads/webinar/thumb/';









				        if(!empty($query[0]['picture'])){

				        	unlink( $path2 . $query[0]['picture'] );

				        	unlink( $path3 . $query[0]['picture'] );







				        }



				        $this->load->model('webinar_model');

				        $this->webinar_model->delete($key);



				        $this->session->set_flashdata('success', 'webinar\'s deleted successfully');

				}



			}



			redirect('admin/webinar/manage_webinar');

		}

	}

	public function check_session()

	{

		if($this->session->userdata('admin_id')=='')

		{

			redirect('admin/admin');

		}

	}
  
  
  	function get_ajaxdataObjects()
	{
      $front_user_id = $this->session->userdata('front_user_id');
    	$admin_SESSION_ID = intval($this->session->userdata('admin_id'));

		$_POST['columns']='A.id, A.webinar_title, A.description, A.date, A.time, A.region, A.speaker_details, A.image, A.registration_link, A.video, A.status, A.created, A.modified';
		$requestData= $_REQUEST;
		//print_r($requestData);die;
		$columns=explode(',',$_POST['columns']);

		$selectColumns=$_POST['columns'];
		//print_r($columns);die;
		//get total number of data without any condition and search term
		if (!empty($front_user_id)) 
	    {
	        $user_id = intval($front_user_id);
	    } 
	    elseif (!empty($admin_SESSION_ID)) 
	    {
	        $user_id = intval($admin_SESSION_ID);
	    } 
	    else 
	    {
	        $user_id = 0;
	    }
		$conditions = array('A.userId' => $user_id);

	    if ($this->session->userdata('admin_level') == 2) 
	    {
	        $conditions['instituteId'] = $this->session->userdata('instituteId');
	    }
		$totalData=$this->modelbasic->bcount_all_only('webinar',$conditions);
		$totalFiltered=$totalData;

		//pass concatColumns only if you want search field to be fetch from concat
		//$concatColumns='B.firstName,B.lastName';
			//$result=$this->webinar_model->run_query('webinar',$requestData,$columns,$selectColumns);
		$resultData = $this->modelbasic->brun_query('webinar', $requestData, $columns, $selectColumns, '', '', '', $conditions);

    	$result = $resultData['result'];
    	$totalFiltered = $resultData['totalFiltered'];
			//print_r($result);die;
			/*if( !empty($requestData['search']['value']) )
			{
				$totalFiltered=count($result);
			}*/
			$data = array();

			if(!empty($result))
			{
				$i=1;
				foreach ($result as $row)
				{
				  $nestedData=array();

				  //$institute_users=$this->modelbasic->get_where_custom('institute_csv_users','instituteId',$row['id']);
				  //$det = $this->db->select('*')->from('institute_csv_users')->where('instituteId',$row['id'])->where('centerId','1')->get()->result_array();

				  $html='';
				 // $det = $institute_users->result_array();
				  /*if(!empty($det))
					{
						$j=1;
						foreach($det as $dt)
						{
							if($dt['status']==1){ $text="<span class='text-success'>Active</span>";}else{ $text="<span class='text-danger'>Deactive</span>";}
							$html.='<tr>
									  <td>'.$j.'</td>'.
									  '<td>'.$dt['studentId'].'</td>'.
				                      '<td>'.$dt['firstName'].'</td>'.
				                	  '<td>'.$dt['lastName'].'</td>'.
				                	  '<td>'.$text.'</td>
				                   </tr>';
				             $j++;
						}
					}
					$nestedData['institute_users']=$html;
					*/
					if($row['status'] == 1)
					{
						$userStatusHtml='<span class="label label-success" style="cursor: auto;">Active</span>';
					}
					else
					{
						$userStatusHtml='<span class="label label-danger" style="cursor: auto;">Deactive</span>';
					}

					//$regionname =$this->db->select('region_name')->from('region_list')->where('id',$row['region'])->get()->row_array();
					//$nestedData['region'] = $regionname['region_name'];

					//$instituteCoverImage=$row["coverImage"];
					//echo $instituteCoverImage;die;
					/*if($instituteCoverImage <> '')
					{
						if(file_exists(file_upload_absolute_path().'institute/coverImage/thumbs/'.$instituteCoverImage))
						{
							$instituteCoverImage = '<img width="100" height="70" src="'.file_upload_base_url().'institute/coverImage/thumbs/'.$instituteCoverImage.'">';
						}
						else
						{
							$instituteCoverImage = '<img width="100" height="70" src="'.base_url().'backend_assets/img/noimage1.png">';
						}
					}
					else
					{
						$instituteCoverImage = '<img width="100" height="70" src="'.base_url().'backend_assets/img/noimage1.png">';
					}

					$instituteLogo=$row["instituteLogo"];
					//echo $instituteCoverImage;die;
					if($instituteLogo <> '')
					{
						if(file_exists(file_upload_absolute_path().'institute/instituteLogo/'.$instituteLogo))
						{
							$instituteLogo = '<img width="100" height="100" src="'.file_upload_base_url().'institute/instituteLogo/'.$instituteLogo.'">';
						}
						else
						{
							$instituteLogo = '<img width="100" height="100" src="'.base_url().'backend_assets/img/noimage1.png">';
						}
					}
					else
					{
						$instituteLogo = '<img width="100" height="100" src="'.base_url().'backend_assets/img/noimage1.png">';
					}*/

					//$profileImage = '<img width="50" height="50" src="'.file_upload_base_url().'users/thumbs/'.$row['profileImage'].'">';
					$nestedData['chk'] = '<input type="checkbox" class="case" id="check" name="checkall['.$row["id"].']" data-index="'.$row["id"].'">';
					$nestedData['id'] =$i+$requestData['start'];
					$nestedData['webinartitle'] = $row["webinar_title"];
					$nestedData['date'] = $row["date"]." ".$row["time"];
					$nestedData['registrationlink'] = $row['registration_link'];
					$nestedData['region'] = $row["region"];



					/*$nestedData['adminprofileImage'] = $profileImage.'<br/><a target="_blank" href="'.front_base_url().'user/userDetail/'.$row["userId"].'">'.$userName.'</a>';
					$nestedData['adminuserId'] = $row["userId"];
					$nestedData['adminuserStatus'] = $userStatusHtml;*/

					$nestedData['created'] = date("d-M-Y", strtotime($row["created"]));
					if($row["status"]==1){ $nestedData['status'] = '<span class="label label-success" style="cursor: pointer;">Active</span>';}else{ $nestedData['status'] = '<span class="label label-danger" onclick="change_status('.$row['id'].')" style="cursor: pointer;">Deactive</span>';}
					$nestedData['action'] = '<span class="menu-action rounded-btn"><a onclick="showInstDetails(this)" data-original-title="view" data-toggle="tooltip" data-placement="top" class="btn menu-icon vd_bd-green vd_green"> <i class="fa fa-eye"></i> </a><a href="'.base_url().'admin/webinar/edit_data/'.$row['id'].'" class="btn menu-icon vd_bd-yellow vd_yellow" title="Edit"> <i class="fa fa-pencil"></i> </a><a class="btn menu-icon vd_bd-red vd_red" onclick="delete_confirm('.$row['id'].')" data-original-title="delete" data-toggle="tooltip" data-placement="top"><i class="fa fa-times"></i></a></span>';
					$data[] = $nestedData;
					$i++;
				}
			}
			$json_data = array(
					"draw"            => intval( $requestData['draw'] ),   // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw.
					"recordsTotal"    => intval( $totalData ),  // total number of records
					"recordsFiltered" => intval( $totalFiltered ), // total number of records after searching, if there is no searching then totalFiltered = totalData
					"data"            => $data   // total data array
					);
			echo json_encode($json_data);
	}

	function edit_data($id){

		$this->form_validation->set_rules('webinar_title','Webinar Title','trim|required|xss_clean|callback_title_check['.$id.']');
	   $this->form_validation->set_rules('description','Webinar Description','trim|xss_clean');

		$this->form_validation->set_rules('date','Date','trim|xss_clean');

		$this->form_validation->set_rules('time','Time','trim|xss_clean');

		$this->form_validation->set_rules('webinar_region','Webinar Region','trim|xss_clean');

		$this->form_validation->set_rules('webinar_speaker_detail','Webinar Speaker Detail','trim|xss_clean');

	    if($this->form_validation->run())

	   	{

			if(!is_dir('uploads/webinar'))

			{

				@mkdir('../uploads/webinar', 0777, TRUE);

			}



			if(!is_dir('uploads/webinar/thumb'))

			{

				@mkdir('../uploads/webinar/thumb', 0777, TRUE);

			}

			//echo 'hi';die;

			$this->load->library('upload');

			$this->load->library('image_lib');

			$config['upload_path'] = '../uploads/webinar/';

			$config['allowed_types'] ='gif|jpg|png|img';

			$this->upload->initialize($config);

			if($_FILES['picture']['size']!=0)

		    {

		     	if($this->upload->do_upload('picture'))

			    {

			    	$img=$this->upload->data();

					$config['image_library'] = 'gd2';

				    $config['source_image'] = '../uploads/webinar/'.$img['file_name'];

					$config['new_image']='../uploads/webinar/thumb/'.$img['file_name'];

					$config['create_thumb'] = FALSE;

					$config['maintain_ratio'] = TRUE;

					$config['width'] = 220;
					$config['height'] = 59;
					$config['master_dim'] = 'width';

				    $this->image_lib->initialize($config);

				    if ( ! $this->image_lib->resize())

					{

					    echo $this->image_lib->display_errors();die;

					}

				}

			    else

		        {

			    	$error=$this->upload->display_errors();

					$this->session->set_flashdata('img',$error);

					redirect('admin/webinar/edit/'.$id);

	 	    	}

			}

			  	if(!isset($img))

		    	{

			 		 $data=array('webinar_title'=>$_POST['webinar_title'],'description'=>$_POST['description'], 'date'=>date('Y-m-d', strtotime($_POST['date'])), 'time'=>date('H:i:s', strtotime($_POST['time'])), 'region'=>$_POST['webinar_region'], 'speaker_details'=>$_POST['webinar_speaker_detail'], 'registration_link'=>$_POST['webinar_link'], 'video'=>$_POST['webinar_video']);

				}

		        else

		        {

				    $this->load->model('webinar_model');

					$query = $this->webinar_model->data($id);

				    if( !empty($query[0]['picture']) || ( !empty( $_FILES['picture']['name'] ) ) )

					{

			        	unlink( '../uploads/webinar/' . $query[0]['picture'] );

			        	unlink( '../uploads/webinar/thumb/' . $query[0]['picture'] );



			        }

		    		$data=array('webinar_title'=>$_POST['webinar_title'],'description'=>$_POST['description'], 'date'=>date('Y-m-d', strtotime($_POST['date'])), 'time'=>date('H:i:s', strtotime($_POST['time'])),'region'=>$_POST['webinar_region'], 'speaker_details'=>$_POST['webinar_speaker_detail'], 'registration_link'=>$_POST['webinar_link'], 'video'=>$_POST['webinar_video'], 'image'=>$img['file_name']);

		        }



		    		$this->load->model('webinar_model');

					$res=$this->webinar_model->update_user($data,$id);

					//print_r($res);die;

		  			if($res > 0)

					{

  						$this->session->set_flashdata('success','Edit successfully');

						redirect('admin/webinar/manage_webinar');

					}

	 				else

				    {

					   $this->session->set_flashdata('Fail','Edit Fail');

 						redirect('admin/webinar/manage_webinar');

				    }

		   }

  		 else

		 {

		  $this->load->model('webinar_model');

			$data['info']=$this->webinar_model->edit($id);
			$this->load->view('admin/webinar/edit_view',$data);

		 }$this->form_validation->set_rules('webinar_link','Website','trim|xss_clean');
		
	}

}











