<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Assessment_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
	public function get_Category($ress)

		{

			$this->db->select('C.category_name',FALSE);

			$this->db->from('assessment_section_category_relations as A');

			$this->db->join('assessment_question_categories as C','A.category_id=C.id');

			$this->db->where('A.section_id',$ress['section_id']);

	        $query = $this->db->get();

	       return $query->result_array();

		}
		public function categorySearch($search)

		{

			$this->db->select('*');

			$this->db->from('assessment_question_categories');

			$this->db->like('category_name',$search);

			return $this->db->get()->result_array();

		}
		public function getAllSectionWhere($res)

		{

			$this->db->select('B.*,C.id as CatId',FALSE);

			$this->db->from('assessment_section_category_relations as A');

			$this->db->join('assessment_section as B','A.section_id=B.id');

			$this->db->join('assessment_question_categories as C','A.category_id=C.id');

			$this->db->where('B.id',$res);

	        $query = $this->db->get();

			return $query->row_array();

		}
		function deleteCatyegory($id)

		{

			$this->db->where('section_id', $id);

			return $this->db->delete('assessment_section_category_relations');

		}
    function run_query($table,$requestData,$columns,$selectColumns,$concatColumns = '',$fieldName='',$institute)
    {
    		$this->db->select($selectColumns,FALSE)->from($table.' as A');
    		$this->db->join('course_type as C','A.course_type=C.id','left');
    		$i=0;
    		if( !empty($requestData['search']['value']) )
    		{
    			foreach ($columns as $value)
    			{
    				if($i==0)
    				{

    					$this->db->like($value,$requestData['search']['value'],'both');
    				}
    				else
    				{
    					if($concatColumns <> '' && $value == $fieldName)
    					{
    						$concat=explode(',', $concatColumns);
    						$this->db->or_like("CONCAT($concat[0],' ', $concat[1])", $requestData['search']['value'], 'both',FALSE);
    					}
    					else
    					{
    						$this->db->or_like($value,$requestData['search']['value'],'both');
    					}
    				}
    				$i++;
    			}
    		}

    		if(!empty($requestData["order"]))
    		{

    			if($requestData["order"][0]["column"] > 2)
    			{
    				$orderby=$requestData["order"][0]["column"]-2;
    			}
    			else
    			{
    				$orderby=3;
    			}

    			if($columns[$orderby] != '')
    			{
    				$orderByField=$columns[$orderby];
    				//echo $orderByField;die;
    				$orderByDirection=$requestData["order"][0]["dir"];
    			}
    			else
    			{
    				$orderByField='created';
    				$orderByDirection='desc';
    			}
    		}
    		else
    		{
    			$orderByField='created';
    			$orderByDirection='desc';
    		}

    		return $this->db->order_by($orderByField,$orderByDirection)->limit($requestData["length"],$requestData["start"])->get()->result_array();
     }

	 public function get_Group($exam_id)

	 {

		 $this->db->select('group_id');

		 $this->db->from('assessment_exam_group_relation');

		 $this->db->where('exam_id',$exam_id);

		 $query = $this->db->get();

		return $query->result_array();

	 }



	 public function get_User($exam_id)

	 {

		 $this->db->select('user_id');

		 $this->db->from('assessment_exam_user_relation');

		 $this->db->where('exam_id',$exam_id);

		 $query = $this->db->get();

		return $query->result_array();

	 }
	 function accessDatabase($tablename,$selectString, $mode, $data_array, $where_array, $join_array="",$limit="")

	 {
 
		 if($mode == 'select')
 
		 {
 
			 $this->db->select($selectString);
 
			 $this->db->from($tablename);
 
			 if(is_array($where_array) && !empty($where_array))
 
			 {
 
				 foreach ($where_array as $key => $value)
 
				 {
 
					 $this->db->where($key,$value);
 
				 }
 
			 }
 
			 if($limit != "")
 
			 {
 
				 if(count($limit)>1)
 
				 {
 
					 $this->db->limit($limit[0] , $limit[1]);
 
				 }
 
				 else
 
				 {
 
					 $this->db->limit($limit);
 
				 }
 
			 }
 
		 }
 
		 elseif($mode=='insert')
 
		 {
 
			 $this->db->insert($tablename,$data_array);
 
			 return $this->db->insert_id();
 
		 }
 
		 elseif($mode=='update')
 
		 {
 
			 $this->db->where($where_array);
 
			 return $this->db->update($tablename,$data_array);
 
		 }
 
		 elseif($mode=='delete')
 
		 {
 
			 return $this->db->delete($tablename,$where_array);
 
		 }
 
		 elseif($mode == 'like')
 
		 {
 
			 $this->db->select($selectString);
 
			 $this->db->from($tablename);
 
			 $this->db->like($where_array);
 
			 if($join_array != '')
 
			 {
 
				 if(is_array($join_array) && !empty($join_array))
 
				 {
 
					 foreach ($join_array as $key => $value)
 
					 {
 
						 $this->db->or_like($key,$value);
 
					 }
 
				 }
 
			 }
 
			 if($data_array != '')
 
			 {
 
				 $this->db->having($data_array);
 
			 }
 
		 }
 
		 elseif($mode=='orderby')
 
		 {
 
			 $this->db->select($selectString);
 
			 $this->db->from($tablename);
 
			 if(is_array($where_array) && !empty($where_array))
 
			 {
 
				 foreach ($where_array as $key => $value)
 
				 {
 
					 $this->db->where($key,$value);
 
				 }
 
			 }
 
			 $this->db->order_by($data_array[0], $data_array[1]);
 
		 }
 
		 elseif($mode=='groupby')
 
		 {
 
			 $this->db->select($selectString);
 
			 $this->db->from($tablename);
 
			 if(is_array($where_array) && !empty($where_array))
 
			 {
 
				 foreach ($where_array as $key => $value)
 
				 {
 
					 $this->db->where($key,$value);
 
				 }
 
			 }
 
			 $this->db->group_by($data_array);
 
		 }
 
		 elseif($mode=='join_order_limit' || $mode=='join_group_limit' || $mode=='join_group_order_limit' || $mode=='join')
 
		 {
 
			 $this->db->select($selectString);
 
			 $this->db->from($tablename);
 
			 if(is_array($join_array) && !empty($join_array))
 
			 {
 
				 foreach ($join_array as $value)
 
				 {
 
					 $this->db->join($value[0],$value[1],'left');
 
				 }
 
			 }
 
			 if(is_array($where_array) && !empty($where_array))
 
			 {
 
				 $this->db->where($where_array);
 
			 }
 
			 if($mode=='join_order_limit' && $data_array != '')
 
			 {
 
				 $this->db->order_by($data_array[0], $data_array[1]);
 
			 }
 
			 if($mode=='join_group_limit' && $data_array != '')
 
			 {
 
				 $this->db->group_by($data_array);
 
			 }
 
			 if($mode=='join_group_order_limit' && $data_array != '')
 
			 {
 
				 $this->db->order_by($data_array[0], $data_array[1]);
 
				 $this->db->group_by($data_array[2]);
 
			 }
 
			 if($limit != "")
 
			 {
 
				 if(count($limit)>1)
 
				 {
 
					 $this->db->limit($limit[0] , $limit[1]);
 
				 }
 
				 else
 
				 {
 
					 $this->db->limit($limit);
 
				 }
 
			 }
 
		 }
 
		 elseif($mode == 'select_like')
 
		 {
 
			 $this->db->select($selectString);
 
			 $this->db->from($tablename);
 
			 if(is_array($where_array) && !empty($where_array))
 
			 {
 
				 foreach ($where_array as $key => $value)
 
				 {
 
					 $this->db->where($key,$value);
 
				 }
 
			 }
 
			  $this->db->like($data_array);
 
		 }
 
		 return $this->db->get();
 
	 }
 
	 function _delete_with_conditions($table,$condition)

	 {
 
		 foreach ($condition as $key => $value)
 
		 {
 
			 $this->db->where($key,$value);
 
		 }
 
		 return $this->db->delete($table);
 
	 }
	 function getValue($table,$getColumn,$conditionArray)

	 {
 
		 $this->db->select($getColumn);
 
		 $this->db->from($table);
 
		 if(is_array($conditionArray) && !empty($conditionArray))
 
		 {
 
			 foreach ($conditionArray as $key => $value)
 
			 {
 
				 $this->db->where($key,$value);
 
			 }
 
		 }
 
		 $result=$this->db->get()->row();
 
		 if(!empty($result))
 
		 {
 
			 return $result->$getColumn;
 
		 }
 
		 else
 
		 {
 
			 return '';
 
		 }
 
	 }
	 
	 function newExamAssignedUserList($exam_id)

	 {

		 $selectUsers=$this->input->post('selectUsers',TRUE);

		 if(!isset($selectUsers) || empty($selectUsers))

		 {

			 $selectUsers=array();

		 }



		 $selectGroups=$this->input->post('selectGroups',TRUE);



		 if(!empty($selectGroups))

		 {

			 $groupUsers=$this->db->select('id')->from('users')->where_in('group_id',$selectGroups)->get()->result_array();

			 if(!empty($groupUsers))

			 {

				 foreach ($groupUsers as $group)

				 {

					 if(!in_array($group['id'],$selectUsers))

					 {

						 $selectUsers[]=$group['id'];

					 }

				 }

			 }

		 }
		// print_r($selectUsers); die;
		 return $selectUsers;

	 }
	 function getValEmailTemp($table,$getColumn,$conditionArray)
	{
		$this->db->select($getColumn);
		$this->db->from($table);
		if(is_array($conditionArray) && !empty($conditionArray))
		{
			foreach ($conditionArray as $key => $value)
			{
				$this->db->where($key,$value);
			}
		}
		return $this->db->get()->row_array();
	}
 	function currentlyAssignedUsers($exam_id)

		{

			$where = "('B.exam_id' = $exam_id OR 'C.exam_id' = $exam_id)";

			return $this->db->select('A.id')->from('users as A')->join('assessment_exam_user_relation as B','A.id=B.user_id','left')->join('assessment_exam_group_relation as C','C.group_id=A.group_id','left')->where($where)->group_by('A.id')->get()->result_array();

		}
		function delete_exam_user_relation($id)

		{

			$this->db->where('exam_id', $id);

			return $this->db->delete('assessment_exam_user_relation');

		}
		public function update_verification_key($uid,$exam_id,$key)
		{
			$this->db->select('id');
			$this->db->where('user_id',$uid);
			$this->db->where('exam_id',$exam_id);
			$this->db->from('assessment_verification_key');
		$res=$this->db->get()->row_array();
		if(empty($res))
		{
			$data=array('user_id'=>$uid,'exam_id'=>$exam_id,'verification_key'=>$key);
			$this->db->insert('assessment_verification_key',$data);
			return $this->db->insert_id();
		}else
		{
			$this->db->where('id',$res['id']);
			return $this->db->update('assessment_verification_key',array('verification_key'=>$key));
		}
	}
	function delete_exam_group_relation($id)

		{

			$this->db->where('exam_id', $id);

			return $this->db->delete('assessment_exam_group_relation');

		}

		function send_mail_to_user_examAdd($exam_id)

		{

			$newExamAssignedUserList=$this->newExamAssignedUserList($exam_id);

			$where = "('B.exam_id' = $exam_id OR 'C.exam_id' = $exam_id)";

			$this->db->select('A.id,A.firstName,A.email,D.exam_name')->from('users as A')->join('assessment_exam_user_relation as B','A.id=B.user_id','left')->join('assessment_exam_group_relation as C','C.group_id=A.group_id','left')->join('assessment_exam_master as D','D.id=B.exam_id OR D.id=C.exam_id','left');

			if(!empty($newExamAssignedUserList))

			{

				$this->db->where_in('A.id',$newExamAssignedUserList);

			}

			$this->db->where($where);

			return $this->db->group_by('A.id')->get()->result_array();

		}
	
		function send_mail_to_user_exam($exam_id,$user_id)

		{

			$where = "(B.exam_id = $exam_id OR C.exam_id = $exam_id)";
			
			$this->db->select('A.id,A.firstName,A.email,D.exam_name')->from('users as A')->join('assessment_exam_user_relation as B','A.id=B.user_id','left')->join('assessment_exam_group_relation as C','C.group_id=A.group_id','left')->join('assessment_exam_master as D','D.id=B.exam_id OR D.id=C.exam_id','left')->where('A.id',$user_id)->where($where);
			return $this->db->group_by('A.id')->get()->row_array();

		}
		public function get_all_settings()

	{

		$this->db->select('*');

		$this->db->from('assessment_settings');

		return $this->db->get()->result_array();

	}
	 function count_all_new($table)
	{
		$qry="SELECT 'id' FROM ".$table." WHERE DATE(created) = DATE(DATE_FORMAT(NOW(),'%Y-%m-%d'))";
		return $this->db->query($qry)->num_rows();
	}

	function count_all_only($table,$condition='',$separator="AND")
	{

		if($condition<>'')
		{
			$i=0;
			foreach ($condition as $key => $value)
			{
				if($separator=='AND')
				{
					$this->db->where($key,$value);
				}
				else
				{
					if($i==0)
					{
						$this->db->where($key,$value);
					}
					else
					{
						$this->db->or_where($key,$value);
					}

				}
				$i++;
			}
		}
		$num_rows = $this->db->count_all_results($table);
		
		return $num_rows;
	}

   

	public function _update($table,$id,$data){
		$this->db->where('id', $id);
		$this->db->update($table, $data);
		return $this->db->affected_rows();
	}
	

	public function get_single_group($id){
		$this->db->select('*')->from('assessment_campaign_groups');		
		$this->db->where('id', $id);		
		return $this->db->get()->row_array();
	}

	public function get_single_level($id){
		$this->db->select('*')->from('assessment_level');		
		$this->db->where('id', $id);		
		return $this->db->get()->row_array();
	}

	function _insert($table,$data){

		$this->db->insert($table, $data);
		return $this->db->insert_id();
	}

	public function getSelectedData($table,$selectString,$conditionArray='',$orderBy='',$dir='',$groupBy='',$limit='',$offset='',$resultMethod='')

	{

		$this->db->select($selectString);

		$this->db->from($table);

		if(is_array($conditionArray) && !empty($conditionArray))

		{

			foreach ($conditionArray as $key => $value)

			{

				$this->db->where($key,$value);

			}

		}

		if($limit != '')

		{

			$this->db->limit($limit);

		}

		if($offset != '')

		{

			$this->db->offset($offset);

		}

		if($orderBy != '')

		{

			$this->db->order_by($orderBy,$dir);

		}

		if($groupBy != '')

		{

			$this->db->group_by($groupBy);

		}

		if($resultMethod != '')

		{

			if($resultMethod == 'row')

			{

				return $this->db->get()->row();

			}

			elseif ($resultMethod == 'row_array')

			{

				return $this->db->get()->row_array();

			}

		}

		else

		{

			return $this->db->get()->result_array();

		}

	}

	public function get_Quiz_Category($ress)

	{

		$this->db->select('B.category_name',FALSE);

		$this->db->from('assessment_mock_quiz_category_relation as A');

		$this->db->join('assessment_question_categories as B','A.category_id=B.id');

		$this->db->where('A.quiz_id',$ress);

			$query = $this->db->get();

		   return $query->result_array();

	}

	function getExportQuery($exam_id)

		{

			$this->db->select('D.id,D.firstName,D.email,E.verification_key',FALSE);

			$this->db->from('assessment_exam_master as A');

			$this->db->join('assessment_exam_user_relation as B','A.id=B.exam_id','left');

			$this->db->join('assessment_exam_group_relation as C','A.id=C.exam_id','left');

			$this->db->join('users as D','B.user_id=D.id OR C.group_id=D.group_id','left');

			$this->db->join('assessment_verification_key as E','E.user_id=D.id','left');

			$this->db->where('A.id', $exam_id);

			$this->db->where('E.exam_id', $exam_id);

			$this->db->group_by('D.id')->get()->result_array();

			//$res=$this->db->group_by('D.id')->get()->result_array();

			//print_r($res);die;

			return $this->db->last_query();

		}

}